/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import me.desht.modularrouters.network.ItemBeamMessage;
import me.desht.modularrouters.network.ModuleFilterMessage;
import me.desht.modularrouters.network.ModuleSettingsMessage;
import me.desht.modularrouters.network.OpenGuiMessage;
import me.desht.modularrouters.network.PushEntityMessage;
import me.desht.modularrouters.network.RouterSettingsMessage;
import me.desht.modularrouters.network.RouterUpgradesSyncMessage;
import me.desht.modularrouters.network.SyncUpgradeSettingsMessage;
import me.desht.modularrouters.network.ValidateModuleMessage;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "2";
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)MiscUtil.RL("main_channel")).clientAcceptedVersions("2"::equals).serverAcceptedVersions("2"::equals).networkProtocolVersion(() -> "2").simpleChannel();
    private static int det = 0;

    private static int nextId() {
        return det++;
    }

    public static void setupNetwork() {
        PacketHandler.register(RouterSettingsMessage.class, RouterSettingsMessage::toBytes, RouterSettingsMessage::new, RouterSettingsMessage::handle, null);
        PacketHandler.register(ItemBeamMessage.class, ItemBeamMessage::toBytes, ItemBeamMessage::new, ItemBeamMessage::handle, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.register(ModuleSettingsMessage.class, ModuleSettingsMessage::toBytes, ModuleSettingsMessage::new, ModuleSettingsMessage::handle, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.register(FilterSettingsMessage.class, FilterSettingsMessage::toBytes, FilterSettingsMessage::new, FilterSettingsMessage::handle, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.register(OpenGuiMessage.class, OpenGuiMessage::toBytes, OpenGuiMessage::new, OpenGuiMessage::handle, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.register(GuiSyncMessage.class, GuiSyncMessage::toBytes, GuiSyncMessage::new, GuiSyncMessage::handle, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.register(SyncUpgradeSettingsMessage.class, SyncUpgradeSettingsMessage::toBytes, SyncUpgradeSettingsMessage::new, SyncUpgradeSettingsMessage::handle, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.register(PushEntityMessage.class, PushEntityMessage::toBytes, PushEntityMessage::new, PushEntityMessage::handle, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.register(RouterUpgradesSyncMessage.class, RouterUpgradesSyncMessage::toBytes, RouterUpgradesSyncMessage::new, RouterUpgradesSyncMessage::handle, NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.register(ValidateModuleMessage.class, ValidateModuleMessage::toBytes, ValidateModuleMessage::new, ValidateModuleMessage::handle, NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.register(ModuleFilterMessage.class, ModuleFilterMessage::toBytes, ModuleFilterMessage::new, ModuleFilterMessage::handle, NetworkDirection.PLAY_TO_SERVER);
    }

    private static <MSG> void register(Class<MSG> messageType, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer, NetworkDirection direction) {
        NETWORK.registerMessage(PacketHandler.nextId(), messageType, encoder, decoder, messageConsumer, Optional.ofNullable(direction));
    }
}

