/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.item.upgrade.SyncUpgrade;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class SyncUpgradeSettingsMessage {
    private final int tunedValue;
    private final InteractionHand hand;

    public SyncUpgradeSettingsMessage(int tunedValue, InteractionHand hand) {
        this.tunedValue = tunedValue;
        this.hand = hand;
    }

    public SyncUpgradeSettingsMessage(FriendlyByteBuf buf) {
        this.tunedValue = buf.readInt();
        this.hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.tunedValue);
        buf.m_130068_((Enum)this.hand);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack held;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (held = player.m_21120_(this.hand)).m_41720_() instanceof SyncUpgrade) {
                SyncUpgrade.setTunedValue(held, this.tunedValue);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

