/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.fake_player.RouterFakePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;

public class BlockUtil {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    private static BlockState getPlaceableState(BlockPlaceContext ctx) {
        try {
            BlockState res = null;
            Level world = ctx.m_43725_();
            BlockPos pos = ctx.m_8083_();
            Item item = ctx.m_43722_().m_41720_();
            if (item instanceof BlockItem) {
                Block block = ((BlockItem)item).m_40614_();
                res = block.m_5573_(ctx);
            } else if (item instanceof IPlantable) {
                res = ((IPlantable)item).getPlant((BlockGetter)world, pos);
            } else if (item == Items.f_42533_) {
                res = BlockUtil.getCocoaBeanState(ctx);
            }
            if (res != null && !res.m_60710_((LevelReader)world, pos)) {
                res = null;
            }
            return res;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static BlockState getCocoaBeanState(BlockPlaceContext ctx) {
        if (ctx.m_43723_() == null) {
            return null;
        }
        for (Direction f : HORIZONTALS) {
            BlockState state = ctx.m_43725_().m_8055_(ctx.m_8083_().m_142300_(f));
            if (state.m_60734_() != Blocks.f_50002_) continue;
            ctx.m_43723_().m_146922_(BlockUtil.getYawFromFacing(f));
            return Blocks.f_50262_.m_5573_(ctx);
        }
        return null;
    }

    private static float getYawFromFacing(Direction facing) {
        return switch (facing) {
            case Direction.WEST -> 90.0f;
            case Direction.NORTH -> 180.0f;
            case Direction.EAST -> 270.0f;
            default -> 0.0f;
        };
    }

    public static BlockState tryPlaceAsBlock(ModularRouterBlockEntity router, ItemStack toPlace, Level world, BlockPos pos, Direction facing) {
        BlockState currentState = world.m_8055_(pos);
        RouterFakePlayer fakePlayer = router.getFakePlayer();
        fakePlayer.m_146922_(BlockUtil.getYawFromFacing(facing));
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, toPlace);
        float hitX = (float)(fakePlayer.m_20185_() - (double)pos.m_123341_());
        float hitY = (float)(fakePlayer.m_20186_() - (double)pos.m_123342_());
        float hitZ = (float)(fakePlayer.m_20189_() - (double)pos.m_123343_());
        BlockHitResult brtr = new BlockHitResult(new Vec3((double)hitX, (double)hitY, (double)hitZ), facing, pos, false);
        BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, brtr));
        if (!currentState.m_60629_(ctx)) {
            return null;
        }
        BlockState newState = BlockUtil.getPlaceableState(ctx);
        if (newState != null) {
            BlockSnapshot snap = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos);
            fakePlayer.m_21008_(InteractionHand.MAIN_HAND, toPlace);
            BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(snap, Blocks.f_50016_.m_49966_(), (Entity)fakePlayer);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled() && world.m_46597_(pos, newState)) {
                fakePlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                BlockItem.m_40582_((Level)world, (Player)fakePlayer, (BlockPos)pos, (ItemStack)toPlace);
                newState.m_60734_().m_6402_(world, pos, newState, (LivingEntity)fakePlayer, toPlace);
                return newState;
            }
        }
        return null;
    }

    public static boolean tryPlaceBlock(ModularRouterBlockEntity router, BlockState newState, Level world, BlockPos pos) {
        if (!(world instanceof ServerLevel) || !world.m_8055_(pos).m_60767_().m_76336_()) {
            return false;
        }
        BlockSnapshot snap = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos);
        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(snap, Blocks.f_50016_.m_49966_(), (Entity)router.getFakePlayer());
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled() && world.m_46597_(pos, newState);
    }

    public static BreakResult tryBreakBlock(ModularRouterBlockEntity router, Level world, BlockPos pos, Filter filter, ItemStack pickaxe) {
        Level level = world;
        if (!(level instanceof ServerLevel)) {
            return BreakResult.NOT_BROKEN;
        }
        ServerLevel serverWorld = (ServerLevel)level;
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (state.m_60795_() || state.m_60800_((BlockGetter)world, pos) < 0.0f || block instanceof LiquidBlock) {
            return BreakResult.NOT_BROKEN;
        }
        RouterFakePlayer fakePlayer = router.getFakePlayer();
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, pickaxe);
        if (MRConfig.Common.Module.breakerHarvestLevelLimit && !ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)fakePlayer)) {
            return BreakResult.NOT_BROKEN;
        }
        List allDrops = Block.m_49874_((BlockState)world.m_8055_(pos), (ServerLevel)serverWorld, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)fakePlayer, (ItemStack)pickaxe);
        Map<Boolean, List<ItemStack>> groups = allDrops.stream().collect(Collectors.partitioningBy(filter));
        if (allDrops.isEmpty() || !groups.get(true).isEmpty()) {
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(world, pos, state, (Player)fakePlayer);
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (!breakEvent.isCanceled()) {
                world.m_7471_(pos, false);
                if (MRConfig.Common.Router.blockBreakXPDrops && breakEvent.getExpToDrop() > 0) {
                    Vec3 vec = Vec3.m_82512_((Vec3i)pos);
                    ExperienceOrb xpOrb = new ExperienceOrb(world, vec.f_82479_, vec.f_82480_, vec.f_82481_, breakEvent.getExpToDrop());
                    world.m_7967_((Entity)xpOrb);
                }
                return new BreakResult(true, groups);
            }
        }
        return BreakResult.NOT_BROKEN;
    }

    public static String getBlockName(Level w, BlockPos pos) {
        return w == null ? "" : w.m_8055_(pos).m_60734_().m_7705_();
    }

    public static class BreakResult {
        static final BreakResult NOT_BROKEN = new BreakResult(false, Collections.emptyMap());
        private final boolean blockBroken;
        private final Map<Boolean, List<ItemStack>> drops;

        BreakResult(boolean blockBroken, Map<Boolean, List<ItemStack>> drops) {
            this.blockBroken = blockBroken;
            this.drops = drops;
        }

        public boolean isBlockBroken() {
            return this.blockBroken;
        }

        List<ItemStack> getFilteredDrops(boolean passed) {
            return this.drops.getOrDefault(passed, Collections.emptyList());
        }

        public void processDrops(Level world, BlockPos pos, IItemHandler handler) {
            for (ItemStack drop : this.getFilteredDrops(true)) {
                ItemStack excess = handler.insertItem(0, drop, false);
                if (excess.m_41619_()) continue;
                InventoryUtils.dropItems(world, Vec3.m_82512_((Vec3i)pos), excess);
            }
            for (ItemStack drop : this.getFilteredDrops(false)) {
                InventoryUtils.dropItems(world, Vec3.m_82512_((Vec3i)pos), drop);
            }
        }
    }
}

