/*
 * Decompiled with CFR 0.152.
 */
package com.ProfitOrange.MoShiz.client;

import com.ProfitOrange.MoShiz.container.GlassCutterContainer;
import com.ProfitOrange.MoShiz.items.recipe.GlasscuttingRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlassCutterGUI
extends ContainerScreen<GlassCutterContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("ms", "textures/gui/container/glasscutter.png");
    private float sliderProgress;
    private boolean clickOnScrollBar;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;

    public GlassCutterGUI(GlassCutterContainer container, PlayerInventory playerInventory, ITextComponent titleIn) {
        super((Container)container, playerInventory, titleIn);
        container.setInventoryUpdateListener(this::onInventoryUpdate);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_145748_c_(), (float)this.field_238744_r_, (float)this.field_238745_s_, 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        int guiLeft = this.field_147003_i;
        int guiTop = this.field_147009_r;
        this.func_238474_b_(matrixStack, guiLeft, guiTop, 0, 0, this.field_146999_f, this.field_147000_g);
        int scrollBarPos = (int)(41.0f * this.sliderProgress);
        this.func_238474_b_(matrixStack, guiLeft + 119, guiTop + 15 + scrollBarPos, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int offsetX = this.field_147003_i + 52;
        int offsetY = this.field_147009_r + 14;
        int indexOffset = this.recipeIndexOffset + 12;
        this.drawRecipeBackgrounds(matrixStack, mouseX, mouseY, offsetX, offsetY, indexOffset);
        this.drawRecipeItems(offsetX, offsetY, indexOffset);
    }

    private void drawRecipeBackgrounds(MatrixStack matrixStack, int mouseX, int mouseY, int offsetX, int offsetY, int indexOffset) {
        for (int i = this.recipeIndexOffset; i < indexOffset && i < ((GlassCutterContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int index = i - this.recipeIndexOffset;
            int recipeOffsetX = offsetX + index % 4 * 16;
            int recipeOffsetY = offsetY + index / 4 * 18 + 2;
            int vOffset = this.field_147000_g;
            if (i == ((GlassCutterContainer)this.field_147002_h).getSelectedRecipe()) {
                vOffset += 18;
            } else if (mouseX >= recipeOffsetX && mouseY >= recipeOffsetY && mouseX < recipeOffsetX + 16 && mouseY < recipeOffsetY + 18) {
                vOffset += 36;
            }
            this.func_238474_b_(matrixStack, recipeOffsetX, recipeOffsetY - 1, 0, vOffset, 16, 18);
        }
    }

    private void drawRecipeItems(int offsetX, int offsetY, int indexOffset) {
        RenderHelper.func_227780_a_();
        List<GlasscuttingRecipe> list = ((GlassCutterContainer)this.field_147002_h).getRecipeList();
        for (int i = this.recipeIndexOffset; i < indexOffset && i < ((GlassCutterContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int index = i - this.recipeIndexOffset;
            int recipeOffsetX = offsetX + index % 4 * 16;
            int recipeOffsetY = offsetY + index / 4 * 18 + 2;
            this.field_230706_i_.func_175599_af().func_180450_b(list.get(i).func_77571_b(), recipeOffsetX, recipeOffsetY);
        }
        RenderHelper.func_74518_a();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.clickOnScrollBar = false;
        if (this.hasItemsInInputSlot) {
            int recipeOffsetX = this.field_147003_i + 52;
            int recipeOffsetY = this.field_147009_r + 14;
            int recipeOffset = this.recipeIndexOffset + 12;
            for (int i = this.recipeIndexOffset; i < recipeOffset; ++i) {
                int index = i - this.recipeIndexOffset;
                double mouseRelativeX = mouseX - (double)(recipeOffsetX + index % 4 * 16);
                double mouseRelativeY = mouseY - (double)(recipeOffsetY + index / 4 * 18);
                if (!(mouseRelativeX >= 0.0) || !(mouseRelativeY >= 0.0) || !(mouseRelativeX < 16.0) || !(mouseRelativeY < 18.0) || !((GlassCutterContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.field_230706_i_.field_71439_g, i)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
                this.field_230706_i_.field_71442_b.func_78756_a(((GlassCutterContainer)this.field_147002_h).field_75152_c, i);
                return true;
            }
            recipeOffsetX = this.field_147003_i + 119;
            recipeOffsetY = this.field_147009_r + 9;
            if (mouseX >= (double)recipeOffsetX && mouseX < (double)(recipeOffsetX + 12) && mouseY >= (double)recipeOffsetY && mouseY < (double)(recipeOffsetY + 54)) {
                this.clickOnScrollBar = true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.clickOnScrollBar && this.canScroll()) {
            int offsetX = this.field_147009_r + 14;
            int width = offsetX + 54;
            this.sliderProgress = ((float)mouseY - (float)offsetX - 7.5f) / ((float)(width - offsetX) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double distance) {
        if (this.canScroll()) {
            int hiddenRowsCount = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - distance / (double)hiddenRowsCount);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)hiddenRowsCount) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((GlassCutterContainer)this.field_147002_h).getRecipeListSize() > 12;
    }

    private int getHiddenRows() {
        return (((GlassCutterContainer)this.field_147002_h).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((GlassCutterContainer)this.field_147002_h).hasItemsInInputSlot();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

