/*
 * Decompiled with CFR 0.152.
 */
package com.ProfitOrange.MoShiz.init;

import com.ProfitOrange.MoShiz.entity.IceSlimeEntity;
import com.ProfitOrange.MoShiz.entity.NetherChickenEntity;
import com.ProfitOrange.MoShiz.entity.NetherSpiderEntity;
import com.ProfitOrange.MoShiz.items.arrow.NeridiumArrowEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MoShizEntityType {
    public static final EntityType<NeridiumArrowEntity> NERIDIUM_ARROW = MoShizEntityType.buildEntity("neridium_arrow", EntityType.Builder.func_220322_a(NeridiumArrowEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(NeridiumArrowEntity::new).setShouldReceiveVelocityUpdates(true).func_220321_a(0.5f, 0.5f));
    public static final EntityType<IceSlimeEntity> ICE_SLIME = MoShizEntityType.buildEntity("ice_slime", EntityType.Builder.func_220322_a(IceSlimeEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(2.04f, 2.04f));
    public static final EntityType<NetherChickenEntity> NETHER_CHICKEN = MoShizEntityType.buildEntity("nether_chicken", EntityType.Builder.func_220322_a(NetherChickenEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.4f, 0.7f).func_233606_a_(10).func_220320_c());
    public static final EntityType<NetherSpiderEntity> NETHER_SPIDER = MoShizEntityType.buildEntity("nether_spider", EntityType.Builder.func_220322_a(NetherSpiderEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.4f, 0.9f).func_233606_a_(8).func_220320_c());

    public static void init(RegistryEvent.Register<EntityType<?>> event) {
        if (!event.getName().equals((Object)ForgeRegistries.ENTITIES.getRegistryName())) {
            return;
        }
        MoShizEntityType.register(event.getRegistry(), "neridium_arrow", NERIDIUM_ARROW);
        MoShizEntityType.register(event.getRegistry(), "ice_slime", ICE_SLIME);
        MoShizEntityType.register(event.getRegistry(), "nether_chicken", NETHER_CHICKEN);
        MoShizEntityType.register(event.getRegistry(), "nether_spider", NETHER_SPIDER);
        MoShizEntityType.registerSpawnConditions();
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String name, T object) {
        object.setRegistryName(MoShizEntityType.locate(name));
        registry.register(object);
    }

    private static <T extends Entity> EntityType<T> buildEntity(String key, EntityType.Builder<T> builder) {
        return builder.func_206830_a(MoShizEntityType.find(key));
    }

    public static boolean canMonsterSpawn(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public static boolean canPeacefulSpawn(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() == Difficulty.PEACEFUL;
    }

    private static void registerSpawnConditions() {
        EntitySpawnPlacementRegistry.func_209343_a(ICE_SLIME, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MoShizEntityType::canMonsterSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(NETHER_SPIDER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MoShizEntityType::canMonsterSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(NETHER_CHICKEN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MoShizEntityType::canPeacefulSpawn);
    }

    public static String find(String name) {
        return new String("ms:" + name);
    }

    public static ResourceLocation locate(String name) {
        return new ResourceLocation("ms", name);
    }
}

