/*
 * Decompiled with CFR 0.152.
 */
package zarak.multibags.backend;

import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zarak.multibags.References;
import zarak.multibags.items.ItemBagBase;
import zarak.multibags.networking.PacketSystem;
import zarak.multibags.networking.packets.SMessageSyncData;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u0004J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lzarak/multibags/backend/DataPlayerMB;", "", "()V", "inv", "Lnet/minecraftforge/items/ItemStackHandler;", "getInv", "()Lnet/minecraftforge/items/ItemStackHandler;", "fromNbt", "", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "getBag", "Lnet/minecraft/item/ItemStack;", "getBagInv", "getBagItem", "Lzarak/multibags/items/ItemBagBase;", "getBagLevel", "", "getBagTag", "sync", "player", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "toNbt", "Companion", "MultiBags"})
public final class DataPlayerMB {
    @NotNull
    private final ItemStackHandler inv = new ItemStackHandler(6);
    private static final HashMap<String, DataPlayerMB> cache;
    private static final HashSet<Pair<String, DataPlayerMB>> toSave;
    private static int ticker;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ItemStackHandler getInv() {
        return this.inv;
    }

    @NotNull
    public final CompoundNBT toNbt(@NotNull CompoundNBT nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.func_218657_a("inv", (INBT)this.inv.serializeNBT());
        return nbt;
    }

    public final void fromNbt(@NotNull CompoundNBT nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.inv.deserializeNBT(nbt.func_74775_l("inv"));
    }

    @NotNull
    public final ItemStack getBag() {
        ItemStack itemStack = this.inv.getStackInSlot(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"inv.getStackInSlot(0)");
        return itemStack;
    }

    @Nullable
    public final ItemBagBase getBagItem() {
        Item item = this.getBag().func_77973_b();
        boolean bl = false;
        boolean bl2 = false;
        Item it = item;
        boolean bl3 = false;
        Object object = it instanceof ItemBagBase ? item : null;
        if (!(object instanceof ItemBagBase)) {
            object = null;
        }
        return (ItemBagBase)((Object)object);
    }

    public final int getBagLevel() {
        ItemBagBase itemBagBase = this.getBagItem();
        return itemBagBase != null ? itemBagBase.getLevel() : -1;
    }

    @NotNull
    public final CompoundNBT getBagTag() {
        CompoundNBT compoundNBT = this.getBag().func_196082_o();
        Intrinsics.checkNotNullExpressionValue((Object)compoundNBT, (String)"getBag().orCreateTag");
        return compoundNBT;
    }

    @NotNull
    public final ItemStackHandler getBagInv() {
        int size = (this.getBagLevel() + 1) * 9;
        ItemStackHandler itemStackHandler = new ItemStackHandler(size);
        itemStackHandler.deserializeNBT(this.getBagTag().func_74775_l("bag_inv"));
        return itemStackHandler;
    }

    public final void sync(@NotNull ServerPlayerEntity player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PacketSystem.INSTANCE.getINSTANCE().send(PacketDistributor.PLAYER.with((Supplier)new Supplier<ServerPlayerEntity>(player){
            final /* synthetic */ ServerPlayerEntity $player;

            public final ServerPlayerEntity get() {
                return this.$player;
            }
            {
                this.$player = serverPlayerEntity;
            }
        }), (Object)new SMessageSyncData(this.toNbt(new CompoundNBT())));
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        cache = new HashMap();
        bl = false;
        toSave = new HashSet();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0005J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0016\u001a\u00020\u0006J\u001a\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u0006H\u0002J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aR*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\f0\u000bj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lzarak/multibags/backend/DataPlayerMB$Companion;", "", "()V", "cache", "Ljava/util/HashMap;", "", "Lzarak/multibags/backend/DataPlayerMB;", "Lkotlin/collections/HashMap;", "ticker", "", "toSave", "Ljava/util/HashSet;", "Lkotlin/Pair;", "Lkotlin/collections/HashSet;", "getOrLoad", "name", "player", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "getPath", "Ljava/nio/file/Path;", "save", "", "data", "save0", "update", "immediately", "", "MultiBags"})
    public static final class Companion {
        public final void update(boolean immediately) {
            Collection collection = toSave;
            boolean bl = false;
            if (!collection.isEmpty()) {
                int n = ticker;
                ticker = n + 1;
                if (n == 100 || immediately) {
                    Iterable $this$forEach$iv = toSave;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl2 = false;
                        Companion.save0((String)it.getFirst(), (DataPlayerMB)it.getSecond());
                    }
                    toSave.clear();
                    ticker = 0;
                }
            }
        }

        @NotNull
        public final DataPlayerMB getOrLoad(@NotNull ServerPlayerEntity player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            GameProfile gameProfile = player.func_146103_bH();
            Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"player.gameProfile");
            String string = gameProfile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.gameProfile.name");
            return this.getOrLoad(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final DataPlayerMB getOrLoad(@NotNull String name) {
            Object it2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Path path = this.getPath(name);
            DataPlayerMB cached = (DataPlayerMB)cache.get(name);
            if (cached != null) {
                return cached;
            }
            if (!Files.exists(path, new LinkOption[0])) {
                return new DataPlayerMB();
            }
            Object object = Files.newBufferedReader(path);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                it2 = (BufferedReader)object;
                boolean bl3 = false;
                it2 = (DataPlayerMB)References.INSTANCE.getGSON().fromJson((Reader)it2, DataPlayerMB.class);
            }
            catch (Throwable it2) {
                throwable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = it2;
            bl = false;
            boolean bl4 = false;
            it2 = object;
            boolean bl5 = false;
            Map map = cache;
            Object object2 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it");
            map.put(name, object2);
            Object object3 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"Files.newBufferedReader(\u2026also { cache[name] = it }");
            return object3;
        }

        public final void save(@NotNull ServerPlayerEntity player, @NotNull DataPlayerMB data) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            GameProfile gameProfile = player.func_146103_bH();
            Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"player.gameProfile");
            String string = gameProfile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.gameProfile.name");
            this.save0(string, data);
        }

        public static /* synthetic */ void save$default(Companion companion, ServerPlayerEntity serverPlayerEntity, DataPlayerMB dataPlayerMB, int n, Object object) {
            if ((n & 2) != 0) {
                GameProfile gameProfile = serverPlayerEntity.func_146103_bH();
                Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"player.gameProfile");
                String string = gameProfile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.gameProfile.name");
                dataPlayerMB = companion.getOrLoad(string);
            }
            companion.save(serverPlayerEntity, dataPlayerMB);
        }

        private final void save0(String name, DataPlayerMB data) {
            Path path = this.getPath(name);
            boolean bl = false;
            boolean bl2 = false;
            Path it = path;
            boolean bl3 = false;
            Files.createDirectories(it.getParent(), new FileAttribute[0]);
            String string = References.INSTANCE.getGSON().toJson((Object)data);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"References.GSON.toJson(data)");
            String string2 = string;
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            Files.write(it, byArray, new OpenOption[0]);
        }

        static /* synthetic */ void save0$default(Companion companion, String string, DataPlayerMB dataPlayerMB, int n, Object object) {
            if ((n & 2) != 0) {
                dataPlayerMB = companion.getOrLoad(string);
            }
            companion.save0(string, dataPlayerMB);
        }

        @NotNull
        public final Path getPath(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Path path = Paths.get("multibags/data/" + name + ".json", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(\"${References.ID}/data/$name.json\")");
            return path;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

