/*
 * Decompiled with CFR 0.152.
 */
package zarak.multibags.backend;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB%\u0012\u0006\u0010\u0002\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0016\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J1\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\n2\b\b\u0002\u0010\u0004\u001a\u00020\n2\b\b\u0002\u0010\u0005\u001a\u00020\n2\b\b\u0002\u0010\u0006\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u0016\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003J&\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000f\u00a8\u0006+"}, d2={"Lzarak/multibags/backend/Rect;", "", "x", "", "y", "w", "h", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "s", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "", "(DDDD)V", "getH", "()D", "setH", "(D)V", "getW", "setW", "getX", "setX", "getY", "setY", "component1", "component2", "component3", "component4", "contains", "", "mx", "my", "copy", "equals", "other", "hashCode", "", "rescaledRect", "wS", "hS", "subRect", "xS", "yS", "toString", "", "MultiBags"})
public final class Rect {
    private double x;
    private double y;
    private double w;
    private double h;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean contains(@NotNull Number mx, @NotNull Number my) {
        Intrinsics.checkNotNullParameter((Object)mx, (String)"mx");
        Intrinsics.checkNotNullParameter((Object)my, (String)"my");
        double dMx = mx.doubleValue();
        double dMy = my.doubleValue();
        double d = this.x;
        double d2 = this.x + this.w;
        double d3 = dMx;
        if (!(d3 >= d)) return false;
        if (!(d3 <= d2)) return false;
        d = this.y;
        d2 = this.y + this.h;
        d3 = dMy;
        if (!(d3 >= d)) return false;
        if (!(d3 <= d2)) return false;
        return true;
    }

    @NotNull
    public final Rect subRect(@NotNull Number xS, @NotNull Number yS, @NotNull Number wS, @NotNull Number hS) {
        Intrinsics.checkNotNullParameter((Object)xS, (String)"xS");
        Intrinsics.checkNotNullParameter((Object)yS, (String)"yS");
        Intrinsics.checkNotNullParameter((Object)wS, (String)"wS");
        Intrinsics.checkNotNullParameter((Object)hS, (String)"hS");
        double xSD = xS.doubleValue();
        double ySD = yS.doubleValue();
        double wSD = wS.doubleValue();
        double hSD = hS.doubleValue();
        if (xSD < 0.0 || ySD < 0.0 || xSD + wSD > this.w || ySD + hSD > this.h) {
            throw (Throwable)new IllegalArgumentException("Sub rect out of range: x=" + this.x + ", y=" + this.y + ",w=" + this.w + ",h=" + this.h);
        }
        return new Rect(this.x + xSD, this.y + ySD, wSD, hSD);
    }

    @NotNull
    public final Rect rescaledRect(@NotNull Number wS, @NotNull Number hS) {
        Intrinsics.checkNotNullParameter((Object)wS, (String)"wS");
        Intrinsics.checkNotNullParameter((Object)hS, (String)"hS");
        double wSD = wS.doubleValue();
        double hSD = hS.doubleValue();
        return new Rect(this.x, this.y, this.w + wSD, this.h + hSD);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Rect && ((Rect)other).x == this.x && ((Rect)other).y == this.y && ((Rect)other).w == this.w && ((Rect)other).h == this.h;
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getW() {
        return this.w;
    }

    public final void setW(double d) {
        this.w = d;
    }

    public final double getH() {
        return this.h;
    }

    public final void setH(double d) {
        this.h = d;
    }

    public Rect(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public Rect(@NotNull Number x, @NotNull Number y, @NotNull Number w, @NotNull Number h) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        this(x.doubleValue(), y.doubleValue(), w.doubleValue(), h.doubleValue());
    }

    public Rect(@NotNull Number x, @NotNull Number y, @NotNull Number s) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this(x.doubleValue(), y.doubleValue(), s.doubleValue(), s.doubleValue());
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.w;
    }

    public final double component4() {
        return this.h;
    }

    @NotNull
    public final Rect copy(double x, double y, double w, double h) {
        return new Rect(x, y, w, h);
    }

    public static /* synthetic */ Rect copy$default(Rect rect, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = rect.x;
        }
        if ((n & 2) != 0) {
            d2 = rect.y;
        }
        if ((n & 4) != 0) {
            d3 = rect.w;
        }
        if ((n & 8) != 0) {
            d4 = rect.h;
        }
        return rect.copy(d, d2, d3, d4);
    }

    @NotNull
    public String toString() {
        return "Rect(x=" + this.x + ", y=" + this.y + ", w=" + this.w + ", h=" + this.h + ")";
    }

    public int hashCode() {
        return ((Double.hashCode(this.x) * 31 + Double.hashCode(this.y)) * 31 + Double.hashCode(this.w)) * 31 + Double.hashCode(this.h);
    }
}

