/*
 * Decompiled with CFR 0.152.
 */
package com.zarak.multibags.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.zarak.multibags.api.ZInventory;
import com.zarak.multibags.common.networking.CPacketSyncCapa;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;

public class BagInventoryCapability {
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static File curDir = null;
    public static HashMap<String, ZInventory> CACHED_INV = new HashMap();

    public static void load(EntityPlayer player) {
        String name = player.func_195047_I_();
        ZInventory handler = new ZInventory(5);
        if (!player.field_70170_p.field_72995_K && curDir.exists()) {
            File file = new File(curDir, "/" + name + "_bag_inv.json");
            try {
                if (file.exists()) {
                    FileReader reader = new FileReader(file);
                    NBTTagCompound nbtTagCompound = JsonToNBT.func_180713_a((String)((String)GSON.fromJson((Reader)reader, String.class)));
                    handler.deserializeNBT(nbtTagCompound);
                }
            }
            catch (Exception e) {
                try {
                    Files.copy(Paths.get(new File(curDir, name + "_bag_inv_error.json").toURI()), Paths.get(file.toURI()), new CopyOption[0]);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        }
        CACHED_INV.put(name, handler);
    }

    public static void save(EntityPlayer player) {
        String name = player.func_195047_I_();
        if (CACHED_INV.containsKey(name)) {
            ZInventory handler = CACHED_INV.get(name);
            try {
                File file = new File(curDir, name + "_bag_inv.json");
                if (!file.exists()) {
                    curDir.mkdirs();
                    file.createNewFile();
                }
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(GSON.toJson((Object)handler.serializeNBT().toString()));
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ZInventory getInv(EntityPlayer player) {
        String name = player.func_195047_I_();
        if (!CACHED_INV.containsKey(name)) {
            BagInventoryCapability.load(player);
            if (player instanceof EntityPlayerMP) {
                BagInventoryCapability.sync((EntityPlayerMP)player);
            }
        }
        return CACHED_INV.get(name);
    }

    public static void sync(EntityPlayerMP player) {
        player.field_71135_a.func_147359_a((Packet)new CPacketSyncCapa(CACHED_INV.get(player.func_195047_I_()).serializeNBT()));
    }

    public static void onDisconnect(EntityPlayer player) {
        String name = player.func_195047_I_();
        BagInventoryCapability.save(player);
        CACHED_INV.remove(name);
    }
}

