/*
 * Decompiled with CFR 0.152.
 */
package com.zarak.multibags.api.recipes;

import com.zarak.multibags.api.recipes.BagRecipe;
import com.zarak.multibags.api.recipes.IBagRecipeReloadListener;
import com.zarak.multibags.api.recipes.JsonToRecipe;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.apache.commons.io.IOUtils;

public class BagRecipeManager
implements ISelectiveResourceReloadListener {
    public static final BagRecipeManager INSTANCE = new BagRecipeManager();
    public static final HashSet<BagRecipe> recipes = new HashSet();
    public static final HashSet<IBagRecipeReloadListener> reloadListeners = new HashSet();

    private BagRecipeManager() {
    }

    public static BagRecipe findRecipe(List<ItemStack> itemStacks) {
        block0: for (BagRecipe recipe : recipes) {
            for (int i = 0; i < recipe.ins.length; ++i) {
                if (!recipe.ins[i].func_77969_a(itemStacks.get(i))) continue block0;
            }
            return recipe;
        }
        return null;
    }

    public static BagRecipe findRecipe(ItemStack[] itemStacks) {
        block0: for (BagRecipe recipe : recipes) {
            for (int i = 0; i < recipe.ins.length; ++i) {
                if (!recipe.ins[i].func_77969_a(itemStacks[i])) continue block0;
            }
            return recipe;
        }
        return null;
    }

    public final void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        recipes.clear();
        reloadListeners.forEach(listener -> listener.onReload(resourceManager));
        resourceManager.func_199003_a("recipes", name -> name.endsWith("_bag.json")).forEach(resourceLocation -> {
            try (IResource resource = resourceManager.func_199002_a(resourceLocation);){
                try {
                    BagRecipe recipe = JsonToRecipe.readRecipe(IOUtils.toString((InputStream)resource.func_199027_b(), (Charset)StandardCharsets.UTF_8));
                    recipes.add(recipe);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

