/*
 * Decompiled with CFR 0.152.
 */
package com.zarak.multibags.api.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.zarak.multibags.api.recipes.BagRecipe;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonToRecipe {
    private static JsonParser parser = new JsonParser();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BagRecipe readRecipe(File file) throws Exception {
        try (JsonReader readerJson = new JsonReader((Reader)new FileReader(file));){
            BagRecipe recipe;
            BagRecipe bagRecipe = recipe = JsonToRecipe.readRecipe((JsonObject)parser.parse(readerJson));
            return bagRecipe;
        }
    }

    public static BagRecipe readRecipe(JsonObject jsonObject) throws Exception {
        boolean isEnable = jsonObject.get("enable").getAsBoolean();
        if (isEnable) {
            JsonObject inputObject = jsonObject.getAsJsonObject("inputs");
            String[] grid = new String[9];
            HashMap<String, ItemStack> ingridients = new HashMap<String, ItemStack>();
            for (Map.Entry entry : inputObject.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("grid")) {
                    JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
                    int counter = 0;
                    for (JsonElement element : array) {
                        String[] splitLine;
                        String[] stringArray = splitLine = element.getAsString().split(" ");
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String s;
                            grid[counter] = s = stringArray[i];
                            ++counter;
                        }
                    }
                    continue;
                }
                String key = (String)entry.getKey();
                JsonObject jsonStack = (JsonObject)entry.getValue();
                ingridients.put(key, JsonToRecipe.parseStack(jsonStack));
            }
            ItemStack[] itemStacks = new ItemStack[9];
            for (int i = 0; i < grid.length; ++i) {
                String s = grid[i];
                ItemStack stack = (ItemStack)ingridients.get(grid[i]);
                if (stack == null) {
                    throw new JsonSyntaxException("Key " + s + " in recipe has not any stack: " + jsonObject);
                }
                itemStacks[i] = stack;
            }
            ItemStack output = JsonToRecipe.parseStack(jsonObject.get("output").getAsJsonObject());
            BagRecipe recipe = new BagRecipe(output, itemStacks);
            return recipe;
        }
        return null;
    }

    public static BagRecipe readRecipe(String json) throws Exception {
        return JsonToRecipe.readRecipe((JsonObject)parser.parse(json));
    }

    private static ItemStack parseStack(JsonObject jsonStack) throws Exception {
        String itemS = jsonStack.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemS));
        if (item == null) {
            throw new JsonSyntaxException("Item " + itemS + " in item JSON is null: " + jsonStack);
        }
        short count = jsonStack.has("count") ? jsonStack.get("count").getAsShort() : (short)1;
        NBTTagCompound nbtTagCompound = jsonStack.has("nbt") ? JsonToNBT.func_180713_a((String)jsonStack.get("nbt").getAsString()) : null;
        return new ItemStack((IItemProvider)item, (int)count, nbtTagCompound);
    }
}

