/*
 * Decompiled with CFR 0.152.
 */
package com.zarak.multibags.jei;

import com.google.common.collect.Lists;
import com.zarak.multibags.api.recipes.BagRecipeManager;
import com.zarak.multibags.common.registry.BlocksMultiBags;
import com.zarak.multibags.jei.JeiBagCategory;
import com.zarak.multibags.jei.JeiBagRecipe;
import java.util.HashSet;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JeiMultibags
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return JeiBagCategory.UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new JeiBagCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        HashSet recipes = new HashSet();
        BagRecipeManager.recipes.forEach(bagRecipe -> {
            JeiBagRecipe recipe = new JeiBagRecipe(Lists.newArrayList((Object[])bagRecipe.ins), bagRecipe.out);
            recipes.add(recipe);
        });
        registration.addRecipes(recipes, new ResourceLocation("multibags", "jei_bag_recipe"));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlocksMultiBags.BAG_UPGRADE), new ResourceLocation[]{JeiBagCategory.UID});
    }
}

