/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.core;

import binary404.mystictools.common.items.ModItems;
import binary404.mystictools.common.loot.LootItemHelper;
import binary404.mystictools.common.loot.effects.IEffectAction;
import binary404.mystictools.common.loot.effects.LootEffect;
import binary404.mystictools.common.loot.effects.UniqueEffect;
import binary404.mystictools.common.network.NetworkHandler;
import binary404.mystictools.common.network.PacketSparkle;
import com.tfar.additionalevents.event.DropLootEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mystictools")
public class EntityHandler {
    @SubscribeEvent
    public static void entityHit(ProjectileImpactEvent.Arrow event) {
        CompoundNBT compound;
        String id;
        UniqueEffect effect;
        if (event.getArrow().getPersistentData().func_74764_b("unique") && (effect = UniqueEffect.getById(id = (compound = event.getArrow().getPersistentData().func_74775_l("unique")).func_74779_i("id"))) != null) {
            effect.arrowImpact(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void sleepingCheck(SleepingLocationCheckEvent event) {
        ItemStack stack;
        if (event.getEntityLiving().func_70608_bn() && !event.getEntityLiving().field_70170_p.func_72935_r() && LootItemHelper.hasEffect(stack = event.getEntityLiving().func_184614_ca(), LootEffect.SLEEP)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        ItemStack stack;
        List<LootEffect> effects;
        PlayerEntity player;
        Entity sourceEntity = event.getSource().func_76346_g();
        if (sourceEntity != null && !sourceEntity.field_70170_p.field_72995_K && sourceEntity instanceof PlayerEntity && (player = (PlayerEntity)sourceEntity).func_184614_ca().func_77973_b() == ModItems.loot_sword && (effects = LootEffect.getEffectList(stack = player.func_184614_ca())).contains(LootEffect.getById("leech"))) {
            float damageInflicted = Math.min(event.getAmount(), event.getEntityLiving().func_110143_aJ());
            int amplifier = LootEffect.getAmplifierFromStack(stack, "leech");
            float leech = damageInflicted * ((float)amplifier / 100.0f);
            player.func_70691_i(leech);
            NetworkHandler.sendToNearby(player.field_70170_p, (Entity)player, (Object)new PacketSparkle(event.getEntityLiving().func_226277_ct_() + 0.5, event.getEntityLiving().func_226278_cu_() + 0.5, event.getEntityLiving().func_226281_cx_() + 0.5, 0.92f, 0.0f, 0.08f));
        }
    }

    @SubscribeEvent
    public static void onHarvest(DropLootEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player != null) {
            ArrayList<Item> tools = new ArrayList<Item>();
            tools.add(ModItems.loot_axe);
            tools.add(ModItems.loot_pickaxe);
            tools.add(ModItems.loot_shovel);
            ItemStack tool = player.func_184614_ca();
            if (tools.contains(tool.func_77973_b())) {
                List<LootEffect> effects = LootEffect.getEffectList(tool);
                for (LootEffect effect : effects) {
                    IEffectAction action = effect.getAction();
                    if (action == null) continue;
                    action.handleHarvest(player, tool, event.getDrops(), event.getPos());
                }
            }
        }
    }
}

