/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.core;

import binary404.mystictools.common.items.ModItems;
import binary404.mystictools.common.loot.LootItemHelper;
import binary404.mystictools.common.loot.LootRarity;
import binary404.mystictools.common.loot.LootSet;
import binary404.mystictools.common.loot.effects.UniqueEffect;
import binary404.mystictools.common.world.UniqueSave;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.server.ServerWorld;

public class UniqueHandler {
    public static void generateUniqueItems(ServerWorld world) {
        UniqueSave.forWorld((ServerWorld)world).uniques.clear();
        for (int i = 0; i < 5; ++i) {
            ItemStack stack = LootItemHelper.getRandomLoot(new Random(), LootRarity.UNIQUE);
            UniqueEffect effect = LootItemHelper.getRandomUnique(new Random(), LootItemHelper.getItemType(stack.func_77973_b()));
            if (stack.func_77973_b().getRegistryName() == null) {
                stack = new ItemStack((IItemProvider)ModItems.loot_pickaxe);
            }
            UniqueSave.UniqueInfo info = new UniqueSave.UniqueInfo(stack.func_77973_b(), effect, false);
            UniqueSave.forWorld((ServerWorld)world).uniques.add(info);
        }
        UniqueSave.forWorld(world).func_76185_a();
    }

    public static void resetUniqueItems(ServerWorld world) {
        UniqueSave.forWorld((ServerWorld)world).uniques.clear();
        UniqueSave.forWorld(world).func_76185_a();
        UniqueHandler.generateUniqueItems(world);
    }

    public static ItemStack getRandomUniqueItem(ServerWorld world) {
        UniqueSave save = UniqueSave.forWorld(world);
        int randomInt = new Random().nextInt(save.uniques.size());
        UniqueSave.UniqueInfo info = save.uniques.get(randomInt);
        if (info.found) {
            save.uniques.set(randomInt, info);
            save.func_76185_a();
            return LootItemHelper.generateLoot(LootRarity.EPIC, LootItemHelper.getItemType(info.item), new ItemStack((IItemProvider)info.item));
        }
        LootSet.LootSetType type = LootItemHelper.getItemType(info.item);
        ItemStack loot = LootItemHelper.generateLoot(LootRarity.UNIQUE, type, new ItemStack((IItemProvider)info.item));
        loot.func_77978_p().func_74775_l("mysticTools").func_218657_a("unique", (INBT)info.effect.getNbt());
        info.found = true;
        save.uniques.set(randomInt, info);
        save.func_76185_a();
        return loot;
    }
}

