/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.core.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.ObjectUtils;

public class Utils {
    public static Vec3d calculateVelocity(Vec3d from, Vec3d to, double heightGain, double gravity) {
        double endGain = to.field_72448_b - from.field_72448_b;
        double horizDist = Math.sqrt(Utils.distanceSquared2d(from, to));
        double gain = heightGain;
        double maxGain = gain > endGain + gain ? gain : endGain + gain;
        double a = -horizDist * horizDist / (4.0 * maxGain);
        double b = horizDist;
        double c = -endGain;
        double slope = -b / (2.0 * a) - Math.sqrt(b * b - 4.0 * a * c) / (2.0 * a);
        double vy = Math.sqrt(maxGain * gravity);
        double vh = vy / slope;
        double dx = to.field_72450_a - from.field_72450_a;
        double dz = to.field_72449_c - from.field_72449_c;
        double mag = Math.sqrt(dx * dx + dz * dz);
        double dirx = dx / mag;
        double dirz = dz / mag;
        double vx = vh * dirx;
        double vz = vh * dirz;
        return new Vec3d(vx, vy, vz);
    }

    public static double distanceSquared2d(Vec3d from, Vec3d to) {
        double dx = to.field_72450_a - from.field_72450_a;
        double dz = to.field_72449_c - from.field_72449_c;
        return dx * dx + dz * dz;
    }

    public static double distanceSquared3d(Vec3d from, Vec3d to) {
        double dx = to.field_72450_a - from.field_72450_a;
        double dy = to.field_72448_b - from.field_72448_b;
        double dz = to.field_72449_c - from.field_72449_c;
        return dx * dx + dy * dy + dz * dz;
    }

    @Nonnull
    public static Optional<ItemStack> findSmeltingResult(World world, ItemStack input) {
        RecipeManager mgr = world.func_199532_z();
        Inventory inv = new Inventory(new ItemStack[]{input});
        Optional optRecipe = (Optional)ObjectUtils.firstNonNull((Object[])new Optional[]{mgr.func_215371_a(IRecipeType.field_222150_b, (IInventory)inv, world), mgr.func_215371_a(IRecipeType.field_222153_e, (IInventory)inv, world), mgr.func_215371_a(IRecipeType.field_222152_d, (IInventory)inv, world), Optional.empty()});
        return optRecipe.map(arg_0 -> Utils.lambda$findSmeltingResult$0((IInventory)inv, arg_0));
    }

    public static void writeCompoundNBTToBuffer(PacketBuffer bb, CompoundNBT nbt) {
        if (nbt == null) {
            bb.writeByte(0);
        } else {
            try {
                CompressedStreamTools.func_74800_a((CompoundNBT)nbt, (DataOutput)new ByteBufOutputStream((ByteBuf)bb));
            }
            catch (IOException ioexception) {
                throw new EncoderException((Throwable)ioexception);
            }
        }
    }

    public static CompoundNBT readCompoundNBTFromBuffer(PacketBuffer bb) {
        int i = bb.readerIndex();
        byte b0 = bb.readByte();
        if (b0 == 0) {
            return null;
        }
        bb.readerIndex(i);
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream((ByteBuf)bb), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static /* synthetic */ ItemStack lambda$findSmeltingResult$0(IInventory inv, IRecipe recipe) {
        return recipe.func_77572_b(inv).func_77946_l();
    }
}

