/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.loot;

import binary404.mystictools.common.core.util.RandomCollection;
import binary404.mystictools.common.items.ModItems;
import binary404.mystictools.common.loot.ItemTypeRegistry;
import binary404.mystictools.common.loot.LootNbtHelper;
import binary404.mystictools.common.loot.LootRarity;
import binary404.mystictools.common.loot.LootSet;
import binary404.mystictools.common.loot.effects.IEffectAction;
import binary404.mystictools.common.loot.effects.LootEffect;
import binary404.mystictools.common.loot.effects.PotionEffect;
import binary404.mystictools.common.loot.effects.UniqueEffect;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;

public class LootItemHelper {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    protected static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    public static ItemStack getRandomLoot(Random rand, LootRarity rarity) {
        RandomCollection<Item> col = new RandomCollection<Item>(rand);
        col.add(3.0, ModItems.loot_sword);
        col.add(2.0, ModItems.loot_axe);
        col.add(2.0, ModItems.loot_pickaxe);
        col.add(2.0, ModItems.loot_shovel);
        col.add(1.0, ModItems.loot_bow);
        ItemStack stack = new ItemStack((IItemProvider)col.next());
        return stack;
    }

    public static LootSet.LootSetType getItemType(Item item) {
        return ItemTypeRegistry.get(item);
    }

    public static String getLootName(ItemStack stack, String current) {
        String name;
        String displayName = current;
        LootRarity rarity = LootRarity.fromId(LootNbtHelper.getLootStringValue(stack, "rarity"));
        displayName = name = LootNbtHelper.getLootStringValue(stack, "loot_name");
        if (rarity != null) {
            displayName = rarity.getColor() + displayName;
        }
        return displayName;
    }

    public static int getMaxDamage(ItemStack stack) {
        int maxDamage = LootNbtHelper.getLootIntValue(stack, "durability");
        if (maxDamage == 0) {
            maxDamage = 100;
        }
        return maxDamage;
    }

    public static Multimap<String, AttributeModifier> modifiersForStack(EquipmentSlotType slot, ItemStack stack, Multimap<String, AttributeModifier> initial, String modifierKey) {
        return LootItemHelper.modifiersForStack(slot, EquipmentSlotType.MAINHAND, stack, initial, modifierKey);
    }

    public static Multimap<String, AttributeModifier> modifiersForStack(EquipmentSlotType slot, EquipmentSlotType effectiveSlot, ItemStack stack, Multimap<String, AttributeModifier> initial, String modifierKey) {
        Multimap<String, AttributeModifier> modifiers = initial;
        if (slot == effectiveSlot) {
            int attackDamage = LootNbtHelper.getLootIntValue(stack, "damage");
            float attackSpeed = LootNbtHelper.getLootFloatValue(stack, "speed");
            float armorPoints = LootNbtHelper.getLootFloatValue(stack, "armor");
            float armorToughness = LootNbtHelper.getLootFloatValue(stack, "toughness");
            if (attackDamage > 0 && !(stack.func_77973_b() instanceof ArmorItem)) {
                LootItemHelper.applyAttributeModifier(modifiers, SharedMonsterAttributes.field_111264_e, ATTACK_DAMAGE_MODIFIER, modifierKey, attackDamage);
            }
            if (attackSpeed > 0.0f && !(stack.func_77973_b() instanceof ArmorItem)) {
                LootItemHelper.applyAttributeModifier(modifiers, SharedMonsterAttributes.field_188790_f, ATTACK_SPEED_MODIFIER, modifierKey, attackSpeed);
            }
            if (armorPoints > 0.0f) {
                LootItemHelper.applyAttributeModifier(modifiers, SharedMonsterAttributes.field_188791_g, ARMOR_MODIFIERS[slot.func_188454_b()], modifierKey, armorPoints);
            }
            if (armorToughness > 0.0f) {
                LootItemHelper.applyAttributeModifier(modifiers, SharedMonsterAttributes.field_189429_h, ARMOR_MODIFIERS[slot.func_188454_b()], modifierKey, armorToughness);
            }
        }
        return modifiers;
    }

    private static void applyAttributeModifier(Multimap<String, AttributeModifier> modifiers, IAttribute attribute, UUID uuid, String modifierKey, double value) {
        ArrayList curModifiers = new ArrayList();
        double attributeValue = 0.0;
        curModifiers.clear();
        curModifiers.addAll(modifiers.get((Object)attribute.func_111108_a()));
        for (AttributeModifier m : curModifiers) {
            attributeValue += m.func_111164_d();
        }
        modifiers.removeAll((Object)attribute.func_111108_a());
        modifiers.put((Object)attribute.func_111108_a(), (Object)new AttributeModifier(uuid, modifierKey, value + attributeValue, AttributeModifier.Operation.ADDITION));
    }

    public static void handleHit(ItemStack stack, LivingEntity target) {
        if (target != null && (double)target.func_110143_aJ() <= 0.0) {
            int kills = LootNbtHelper.getLootIntValue(stack, "xp");
            int level = LootNbtHelper.getLootIntValue(stack, "level");
            if (++kills >= level) {
                level = (int)((double)level * 1.5);
                kills = 0;
                int upgrades = LootNbtHelper.getLootIntValue(stack, "upgrade");
                LootNbtHelper.setLootIntValue(stack, "level", level);
                LootNbtHelper.setLootIntValue(stack, "upgrade", upgrades + 1);
            }
            LootNbtHelper.setLootIntValue(stack, "xp", kills);
        }
    }

    public static void handleBreak(ItemStack stack, PlayerEntity player, BlockPos pos) {
        if (player.field_70170_p.field_73012_v.nextInt(10) <= 5) {
            int xp = LootNbtHelper.getLootIntValue(stack, "xp");
            int level = LootNbtHelper.getLootIntValue(stack, "level");
            if (++xp >= level) {
                level = (int)((double)level * 1.5);
                xp = 0;
                int upgrades = LootNbtHelper.getLootIntValue(stack, "upgrade");
                LootNbtHelper.setLootIntValue(stack, "level", level);
                LootNbtHelper.setLootIntValue(stack, "upgrade", upgrades + 1);
            }
            LootNbtHelper.setLootIntValue(stack, "xp", xp);
        }
    }

    public static ActionResult<ItemStack> use(ActionResult<ItemStack> defaultAction, World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184614_ca();
        List<LootEffect> effects = LootEffect.getEffectList(stack);
        if (effects != null) {
            for (LootEffect effect : effects) {
                IEffectAction action;
                if (effect == null || (action = effect.getAction()) == null) continue;
                defaultAction = action.handleUse(defaultAction, world, player, hand);
            }
        }
        return defaultAction;
    }

    public static boolean hasEffect(ItemStack stack, LootEffect effect) {
        boolean hasEffect = false;
        List<LootEffect> effects = LootEffect.getEffectList(stack);
        for (LootEffect e : effects) {
            if (e != effect) continue;
            hasEffect = true;
            break;
        }
        return hasEffect;
    }

    public static void handlePotionEffects(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        List<PotionEffect> effects = PotionEffect.getPotionlist(stack);
        if (effects.size() > 0) {
            for (PotionEffect effect : effects) {
                effect.onHit(PotionEffect.getDurationFromStack(stack, effect.getId()), PotionEffect.getAmplifierFromStack(stack, effect.getId()), target, attacker);
            }
        }
    }

    public static PotionEffect getRandomPotionExcluding(Random rand, LootSet.LootSetType type, List<PotionEffect> exclude) {
        PotionEffect effect = null;
        ArrayList<PotionEffect> list = new ArrayList<PotionEffect>();
        for (PotionEffect e : PotionEffect.REGISTRY.values()) {
            if (!e.applyToItemType(type)) continue;
            list.add(e);
        }
        list.removeAll(exclude);
        if (list.size() > 0) {
            effect = (PotionEffect)list.get(rand.nextInt(list.size()));
        }
        return effect;
    }

    public static UniqueEffect getRandomUnique(Random rand, LootSet.LootSetType type) {
        UniqueEffect effect = null;
        ArrayList<UniqueEffect> list = new ArrayList<UniqueEffect>();
        for (UniqueEffect e : UniqueEffect.REGISTRY.values()) {
            if (!e.applyToItemType(type)) continue;
            list.add(e);
        }
        if (list.size() > 0) {
            effect = (UniqueEffect)list.get(rand.nextInt(list.size()));
        }
        return effect;
    }

    public static float getEfficiency(ItemStack stack, BlockState state) {
        float speed = LootNbtHelper.getLootFloatValue(stack, "efficiency");
        for (ToolType type : stack.func_77973_b().getToolTypes(stack)) {
            Material material = state.func_185904_a();
            if (!state.func_177230_c().isToolEffective(state, type) && (type != ToolType.PICKAXE || material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e) && (type != ToolType.AXE || material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151584_j)) continue;
            return speed;
        }
        return 1.0f;
    }

    public static void addInformation(ItemStack stack, List<ITextComponent> tooltip) {
        LootItemHelper.addInformation(stack, tooltip, true);
    }

    public static void addInformation(ItemStack stack, List<ITextComponent> tooltip, boolean show_durability) {
        int modifiers;
        int n;
        int durability = stack.func_77958_k();
        List<PotionEffect> effects = PotionEffect.getPotionlist(stack);
        for (PotionEffect potionEffect : effects) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RESET + "- " + potionEffect.getType().getColor() + I18n.func_135052_a((String)("weaponeffect." + potionEffect.getId() + ".description"), (Object[])new Object[]{potionEffect.getDurationString(stack, potionEffect.getId()), potionEffect.getAmplifierString(stack, potionEffect.getId()), potionEffect.getAmplifierString(stack, potionEffect.getId(), 1)})));
        }
        List<LootEffect> effects1 = LootEffect.getEffectList(stack);
        for (LootEffect lootEffect : effects1) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RESET + "- " + lootEffect.getType().getColor() + I18n.func_135052_a((String)("weaponeffect." + lootEffect.getId() + ".description"), (Object[])new Object[]{lootEffect.getAmplifierString(stack, lootEffect.getId()), lootEffect.getAmplifierString(stack, lootEffect.getId(), 1)})));
        }
        LootRarity lootRarity = LootRarity.fromId(LootNbtHelper.getLootStringValue(stack, "rarity"));
        if (lootRarity == LootRarity.UNIQUE) {
            String string = I18n.func_135052_a((String)(stack.func_77978_p().func_74775_l("mysticTools").func_74775_l("unique").func_74779_i("id") + ".description"), (Object[])new Object[0]);
            tooltip.add((ITextComponent)new StringTextComponent("+ " + TextFormatting.ITALIC + "" + TextFormatting.DARK_PURPLE + "" + string));
        }
        if (lootRarity != null) {
            tooltip.add((ITextComponent)new StringTextComponent("Rarity: " + lootRarity.getColor() + lootRarity.getId()));
        }
        if (show_durability) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RESET + "" + durability + "" + TextFormatting.GRAY + " Durability"));
        }
        if ((n = LootNbtHelper.getLootIntValue(stack, "xp")) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "" + n + " Xp/" + LootNbtHelper.getLootIntValue(stack, "level")));
        }
        if ((modifiers = LootNbtHelper.getLootIntValue(stack, "upgrade")) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BOLD + "" + modifiers + " Modifiers"));
        }
    }

    @Nullable
    public static LootEffect getRandomEffectExcluding(Random rand, LootSet.LootSetType type, List<LootEffect> exclude) {
        LootEffect weaponEffect = null;
        boolean hasActive = false;
        boolean hasUse = false;
        for (LootEffect ex : exclude) {
            if (ex.getType() == LootEffect.EffectType.ACTIVE) {
                hasActive = true;
            }
            if (ex.getType() != LootEffect.EffectType.USE) continue;
            hasUse = true;
        }
        ArrayList<LootEffect> list = new ArrayList<LootEffect>();
        for (LootEffect e : LootEffect.REGISTRY.values()) {
            if (!e.applyToItemType(type) || hasActive && e.getType() == LootEffect.EffectType.ACTIVE || hasUse && e.getType() == LootEffect.EffectType.USE) continue;
            list.add(e);
        }
        list.removeAll(exclude);
        if (list.size() > 0) {
            weaponEffect = (LootEffect)list.get(rand.nextInt(list.size()));
        }
        return weaponEffect;
    }

    public static ItemStack rerollStats(ItemStack stack) {
        Random random = new Random();
        LootRarity lootRarity = LootRarity.fromId(LootNbtHelper.getLootStringValue(stack, "rarity"));
        LootNbtHelper.setLootIntValue(stack, "damage", lootRarity.getDamage(random));
        LootNbtHelper.setLootFloatValue(stack, "speed", lootRarity.getSpeed(random));
        LootNbtHelper.setLootFloatValue(stack, "efficiency", lootRarity.getEfficiency(random));
        LootNbtHelper.setLootIntValue(stack, "durability", lootRarity.getDurability(random));
        LootNbtHelper.setLootFloatValue(stack, "drawspeed", lootRarity.getSpeed(random) + 4.0f);
        LootNbtHelper.setLootFloatValue(stack, "power", 1.0f + (float)lootRarity.getDamage(random) / 20.0f);
        return stack;
    }

    public static ItemStack generateLoot(LootRarity lootRarity, LootSet.LootSetType type, ItemStack loot) {
        int m;
        ListNBT effectList;
        ArrayList<PotionEffect> appliedEffects;
        Random random = new Random();
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("HideFlags", 2);
        CompoundNBT lootTag = new CompoundNBT();
        int model = 1 + random.nextInt(type.models);
        lootTag.func_74768_a("model", model);
        lootTag.func_74778_a("uuid", UUID.randomUUID().toString());
        lootTag.func_74778_a("rarity", lootRarity.getId());
        lootTag.func_74768_a("damage", lootRarity.getDamage(random));
        lootTag.func_74776_a("speed", lootRarity.getSpeed(random));
        lootTag.func_74776_a("efficiency", lootRarity.getEfficiency(random));
        lootTag.func_74768_a("durability", lootRarity.getDurability(random));
        lootTag.func_74768_a("level", 10);
        lootTag.func_74768_a("upgrade", 0);
        lootTag.func_74776_a("drawspeed", lootRarity.getSpeed(random) + 4.0f);
        lootTag.func_74776_a("power", 1.0f + (float)lootRarity.getDamage(random) / 20.0f);
        int modifierCount = lootRarity.getPotionCount(random);
        boolean unbreakable = false;
        if (lootRarity == LootRarity.UNIQUE) {
            unbreakable = true;
        }
        if (modifierCount > 0) {
            appliedEffects = new ArrayList<PotionEffect>();
            effectList = new ListNBT();
            for (m = 0; m < modifierCount; ++m) {
                PotionEffect effect = LootItemHelper.getRandomPotionExcluding(random, type, appliedEffects);
                if (effect == null) continue;
                effectList.add((Object)effect.getNbt(random));
                appliedEffects.add(effect);
            }
            if (lootRarity != LootRarity.COMMON && random.nextInt(100) > 90) {
                unbreakable = true;
            }
            lootTag.func_218657_a("potionList", (INBT)effectList);
        }
        if ((modifierCount = lootRarity.getEffectCount(random)) > 0) {
            appliedEffects = new ArrayList();
            effectList = new ListNBT();
            for (m = 0; m < modifierCount; ++m) {
                LootEffect me = LootItemHelper.getRandomEffectExcluding(random, type, appliedEffects);
                if (me == null) continue;
                effectList.add((Object)me.getNbt(random));
                appliedEffects.add((PotionEffect)((Object)me));
            }
            lootTag.func_218657_a("effectList", (INBT)effectList);
        }
        tag.func_218657_a("mysticTools", (INBT)lootTag);
        if (unbreakable) {
            tag.func_74757_a("Unbreakable", true);
        }
        loot.func_77982_d(tag);
        String loot_name = LootSet.getNameForType(type, random);
        if (loot_name.length() > 0) {
            LootNbtHelper.setLootStringValue(loot, "loot_name", loot_name);
        }
        return loot;
    }

    public static RayTraceResult getBlockOnReach(World world, PlayerEntity player) {
        double distance = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        double x = player.func_226277_ct_();
        double y = player.func_226278_cu_() + (double)player.func_70047_e();
        double z = player.func_226281_cx_();
        Vec3d vec3 = new Vec3d(x, y, z);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3d vec31 = vec3.func_72441_c((double)f6 * distance, (double)f5 * distance, (double)f7 * distance);
        return world.func_217299_a(new RayTraceContext(vec3, vec31, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
    }

    public static boolean breakBlocks(ItemStack stack, int level, World world, BlockPos aPos, Direction side, PlayerEntity player) {
        BlockState theState;
        int xradN = 0;
        int xradP = 0;
        int yradN = 0;
        int yradP = 0;
        int zradN = 0;
        int zradP = 0;
        switch (level) {
            case 1: {
                xradN = 0;
                xradP = 1;
                yradN = 1;
                yradP = 0;
                zradN = 0;
                zradP = 0;
                break;
            }
            case 2: {
                xradN = 1;
                xradP = 1;
                yradN = 1;
                yradP = 1;
                zradN = 0;
                zradP = 0;
                break;
            }
            case 3: {
                xradN = 1;
                xradP = 2;
                yradN = 1;
                yradP = 2;
                zradN = 0;
                zradP = 0;
                break;
            }
            case 4: {
                xradN = 2;
                xradP = 2;
                yradN = 2;
                yradP = 2;
                zradN = 0;
                zradP = 0;
                break;
            }
            default: {
                xradN = 0;
                xradP = 0;
                yradN = 0;
                yradP = 0;
                zradN = 0;
                zradP = 0;
            }
        }
        if (side.func_176740_k() == Direction.Axis.Y) {
            zradN = xradN;
            zradP = xradP;
            yradN = 0;
            yradP = 0;
        }
        if (side.func_176740_k() == Direction.Axis.X) {
            xradN = 0;
            xradP = 0;
            zradN = yradN;
            zradP = yradP;
        }
        BlockState state = world.func_180495_p(aPos);
        float mainHardness = state.func_185887_b((IBlockReader)world, aPos);
        if (!LootItemHelper.tryHarvestBlock(world, aPos, false, stack, player)) {
            return false;
        }
        if (level == 4 && side.func_176740_k() != Direction.Axis.Y && (theState = world.func_180495_p(aPos = aPos.func_177984_a())).func_185887_b((IBlockReader)world, aPos) <= mainHardness + 5.0f) {
            LootItemHelper.tryHarvestBlock(world, aPos, true, stack, player);
        }
        if (level > 0 && mainHardness >= 0.2f) {
            for (int xPos = aPos.func_177958_n() - xradN; xPos <= aPos.func_177958_n() + xradP; ++xPos) {
                for (int yPos = aPos.func_177956_o() - yradN; yPos <= aPos.func_177956_o() + yradP; ++yPos) {
                    for (int zPos = aPos.func_177952_p() - zradN; zPos <= aPos.func_177952_p() + zradP; ++zPos) {
                        BlockPos thePos;
                        BlockState theState2;
                        if (aPos.func_177958_n() == xPos && aPos.func_177956_o() == yPos && aPos.func_177952_p() == zPos || !((theState2 = world.func_180495_p(thePos = new BlockPos(xPos, yPos, zPos))).func_185887_b((IBlockReader)world, thePos) <= mainHardness + 5.0f)) continue;
                        LootItemHelper.tryHarvestBlock(world, thePos, true, stack, player);
                    }
                }
            }
        }
        return true;
    }

    public static boolean tryHarvestBlock(World world, BlockPos pos, boolean isExtra, ItemStack stack, PlayerEntity player) {
        boolean canHarvest;
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        boolean bl = canHarvest = !(!ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos) && !stack.func_77973_b().func_150897_b(state) || isExtra && !(stack.func_77973_b().func_150893_a(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!isExtra || canHarvest && !block.hasTileEntity(world.func_180495_p(pos)))) {
            return LootItemHelper.breakExtraBlock(stack, world, player, pos);
        }
        return false;
    }

    public static boolean breakExtraBlock(ItemStack stack, World world, PlayerEntity player, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (player.field_71075_bZ.field_75098_d) {
            if (block.removedByPlayer(state, world, pos, player, false, world.func_204610_c(pos))) {
                block.func_176206_d((IWorld)world, pos, state);
            }
            if (!world.field_72995_K) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
            }
            return true;
        }
        stack.func_179548_a(world, state, pos, player);
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((ServerPlayerEntity)player).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)player), (BlockPos)pos);
            if (xp == -1) {
                return false;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (block.removedByPlayer(state, world, pos, player, true, world.func_204610_c(pos))) {
                block.func_176206_d((IWorld)world, pos, state);
                block.func_180657_a(world, player, pos, state, tileEntity, stack);
                block.func_180637_b(world, pos, xp);
            }
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
            return true;
        }
        world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
        if (block.removedByPlayer(state, world, pos, player, true, world.func_204610_c(pos))) {
            block.func_176206_d((IWorld)world, pos, state);
        }
        stack.func_179548_a(world, state, pos, player);
        return true;
    }
}

