/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.loot;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public class LootRarity {
    private static final Map<String, LootRarity> REGISTRY = new HashMap<String, LootRarity>();
    public static final LootRarity COMMON = LootRarity.get("Common", TextFormatting.WHITE).setDamage(6, 12).setSpeed(-3.1f, -2.399f).setArmor(0.0f, 1.0f).setToughness(0.0f, 0.0f).setEfficiency(5.0f, 12.0f).setDurability(100, 500).setPotionCount(0, 1).setEffectCount(0, 0);
    public static final LootRarity UNCOMMON = LootRarity.get("Uncommon", TextFormatting.GRAY).setDamage(9, 16).setSpeed(-2.8f, -2.3f).setArmor(1.0f, 3.0f).setToughness(1.0f, 3.0f).setEfficiency(11.0f, 25.0f).setDurability(350, 1450).setPotionCount(0, 3).setEffectCount(1, 2);
    public static final LootRarity RARE = LootRarity.get("Rare", TextFormatting.YELLOW).setDamage(12, 29).setSpeed(-2.6999f, -2.1f).setArmor(2.0f, 5.0f).setToughness(2.0f, 5.0f).setEfficiency(15.0f, 40.0f).setDurability(850, 2500).setPotionCount(1, 4).setEffectCount(2, 4);
    public static final LootRarity EPIC = LootRarity.get("Epic", TextFormatting.BLUE).setDamage(16, 34).setSpeed(-2.39999f, -1.8f).setArmor(2.0f, 5.0f).setToughness(1.0f, 5.0f).setEfficiency(20.0f, 42.0f).setDurability(2000, 4500).setPotionCount(2, 5).setEffectCount(2, 4);
    public static final LootRarity UNIQUE = LootRarity.get("Unique", TextFormatting.DARK_PURPLE).setDamage(20, 54).setSpeed(-2.0f, -1.5f).setArmor(3.0f, 7.0f).setToughness(2.0f, 6.0f).setEfficiency(20.56f, 56.05f).setDurability(1000, 4000).setPotionCount(3, 6).setEffectCount(3, 5);
    private TextFormatting color = TextFormatting.WHITE;
    private int damageMin = 0;
    private int damageMax = 7;
    private float speedMin = 0.0f;
    private float speedMax = 1.0f;
    private float armorMin = 3.0f;
    private float armorMax = 10.0f;
    private float toughnessMin = 3.0f;
    private float tougnessMax = 10.0f;
    private float efficiencyMin = 1.0f;
    private float efficiencyMax = 1.0f;
    private int durabilityMin = 0;
    private int durabilityMax = 0;
    private int potionMin = 0;
    private int potionMax = 1;
    private int effectMin = 0;
    private int effectMax = 1;
    private String id;

    private LootRarity() {
    }

    public TextFormatting getColor() {
        return this.color;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public static LootRarity fromId(String id) {
        LootRarity r = null;
        if (REGISTRY.containsKey(id)) {
            r = REGISTRY.get(id);
        }
        return r;
    }

    protected LootRarity setPotionCount(int min, int max) {
        this.potionMin = min;
        this.potionMax = max;
        return this;
    }

    protected LootRarity setEffectCount(int min, int max) {
        this.effectMin = min;
        this.effectMax = max;
        return this;
    }

    protected LootRarity setDurability(int min, int max) {
        this.durabilityMin = min;
        this.durabilityMax = max;
        return this;
    }

    protected LootRarity setDamage(int min, int max) {
        this.damageMin = min;
        this.damageMax = max;
        return this;
    }

    protected LootRarity setSpeed(float min, float max) {
        this.speedMin = min;
        this.speedMax = max;
        return this;
    }

    protected LootRarity setArmor(float min, float max) {
        this.armorMin = min;
        this.armorMax = max;
        return this;
    }

    protected LootRarity setToughness(float min, float max) {
        this.toughnessMin = min;
        this.tougnessMax = max;
        return this;
    }

    protected LootRarity setEfficiency(float min, float max) {
        this.efficiencyMin = min;
        this.efficiencyMax = max;
        return this;
    }

    public int getPotionCount(Random rand) {
        int modifierCount = this.potionMin;
        if (modifierCount < this.potionMax) {
            modifierCount += rand.nextInt(this.potionMax - modifierCount + 1);
        }
        return modifierCount;
    }

    public int getEffectCount(Random rand) {
        int modifierCount = this.effectMin;
        if (modifierCount < this.effectMax) {
            modifierCount += rand.nextInt(this.effectMax - modifierCount + 1);
        }
        return modifierCount;
    }

    public int getDurability(Random rand) {
        int durability = this.durabilityMin;
        if (durability < this.durabilityMax) {
            durability += rand.nextInt(this.durabilityMax - durability + 1);
        }
        return durability;
    }

    public int getDamage(Random rand) {
        int damage = this.damageMin;
        if (damage < this.damageMax) {
            damage += rand.nextInt(this.damageMax - damage + 1);
        }
        return damage;
    }

    public float getSpeed(Random rand) {
        float speed = this.speedMin;
        speed += (this.speedMax - speed) * rand.nextFloat();
        return speed;
    }

    public float getArmor(Random rand) {
        float armor = this.armorMin;
        armor += (this.armorMax - armor) * rand.nextFloat();
        armor = (float)Math.round(armor * 100.0f) / 100.0f;
        return armor;
    }

    public float getToughness(Random rand) {
        float toughness = this.toughnessMin;
        toughness += (this.tougnessMax - toughness) * rand.nextFloat();
        toughness = (float)Math.round(toughness * 100.0f) / 100.0f;
        return toughness;
    }

    public float getEfficiency(Random rand) {
        float efficiency = this.efficiencyMin;
        efficiency += (this.efficiencyMax - efficiency) * rand.nextFloat();
        return efficiency;
    }

    protected static LootRarity get(String id, TextFormatting color) {
        LootRarity r = new LootRarity();
        r.id = id;
        r.color = color;
        REGISTRY.put(id, r);
        return r;
    }
}

