/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.loot.effects;

import binary404.mystictools.common.loot.LootNbtHelper;
import binary404.mystictools.common.loot.LootSet;
import binary404.mystictools.common.loot.effects.IEffectAction;
import binary404.mystictools.common.loot.effects.effect.LootEffectAreaMiner;
import binary404.mystictools.common.loot.effects.effect.LootEffectAutoSmelt;
import binary404.mystictools.common.loot.effects.effect.LootEffectLightning;
import binary404.mystictools.common.loot.effects.effect.LootEffectSleep;
import binary404.mystictools.common.loot.effects.effect.LootEffectVoid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class LootEffect {
    public static final Map<String, LootEffect> REGISTRY = new HashMap<String, LootEffect>();
    public static final LootEffect LIGHTNING = LootEffect.create("lightning", EffectType.PASSIVE).setAction(new LootEffectLightning()).setItemTypes(LootSet.LootSetType.SWORD);
    public static final LootEffect LEECH = LootEffect.create("leech", EffectType.PASSIVE).setAmplifier(1, 100).setItemTypes(LootSet.LootSetType.SWORD);
    public static final LootEffect SLEEP = LootEffect.create("sleep", EffectType.USE).setAction(new LootEffectSleep()).setItemTypes(LootSet.LootSetType.PICKAXE, LootSet.LootSetType.AXE, LootSet.LootSetType.SHOVEL);
    public static final LootEffect MULTI = LootEffect.create("multi", EffectType.PASSIVE).setItemTypes(LootSet.LootSetType.AXE, LootSet.LootSetType.SHOVEL, LootSet.LootSetType.PICKAXE);
    public static final LootEffect AREA_MINER = LootEffect.create("area_miner", EffectType.ACTIVE).setItemTypes(LootSet.LootSetType.PICKAXE, LootSet.LootSetType.SHOVEL, LootSet.LootSetType.AXE).setAction(new LootEffectAreaMiner());
    public static final LootEffect AUTO_SMELT = LootEffect.create("auto_smelt", EffectType.ACTIVE).setItemTypes(LootSet.LootSetType.PICKAXE, LootSet.LootSetType.SHOVEL, LootSet.LootSetType.AXE).setAction(new LootEffectAutoSmelt());
    public static final LootEffect VOID = LootEffect.create("void", EffectType.ACTIVE).setItemTypes(LootSet.LootSetType.PICKAXE, LootSet.LootSetType.AXE, LootSet.LootSetType.SHOVEL).setAction(new LootEffectVoid());
    private String id;
    private List<LootSet.LootSetType> applyToItems = new ArrayList<LootSet.LootSetType>();
    private IEffectAction action;
    private int amplifierMin = 0;
    private int amplifierMax = 0;
    private final EffectType effectType;

    private LootEffect(EffectType type) {
        this.effectType = type;
    }

    public EffectType getType() {
        return this.effectType;
    }

    public boolean applyToItemType(LootSet.LootSetType type) {
        return this.applyToItems.contains((Object)type);
    }

    public IEffectAction getAction() {
        return this.action;
    }

    protected LootEffect setAction(IEffectAction action) {
        this.action = action;
        return this;
    }

    protected LootEffect setItemTypes(LootSet.LootSetType ... itemTypes) {
        for (LootSet.LootSetType itemType : itemTypes) {
            this.applyToItems.add(itemType);
        }
        return this;
    }

    public static LootEffect getById(String id) {
        LootEffect weaponEffect = REGISTRY.get(id);
        return weaponEffect;
    }

    public String getId() {
        return this.id;
    }

    public CompoundNBT getNbt(Random rand) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("id", this.getId());
        tag.func_74768_a("amplifier", this.getAmplifier(rand));
        return tag;
    }

    public static int getAmplifierFromStack(ItemStack stack, String effectId) {
        int amplifier = 0;
        ListNBT effectTagList = LootNbtHelper.getLootTagList(stack, "effectList");
        int count = effectTagList.size();
        for (int i = 0; i < count; ++i) {
            CompoundNBT e = effectTagList.func_150305_b(i);
            if (!e.func_74779_i("id").contains(effectId)) continue;
            amplifier = e.func_74762_e("amplifier");
        }
        return amplifier;
    }

    public static List<LootEffect> getEffectList(ItemStack stack) {
        ArrayList<LootEffect> list = new ArrayList<LootEffect>();
        ListNBT effectList = LootNbtHelper.getLootTagList(stack, "effectList");
        int count = effectList.size();
        for (int i = 0; i < count; ++i) {
            CompoundNBT e = effectList.func_150305_b(i);
            list.add(LootEffect.getById(e.func_74779_i("id")));
        }
        return list;
    }

    protected static LootEffect create(String id, EffectType type) {
        LootEffect effect = new LootEffect(type);
        effect.id = id;
        REGISTRY.put(id, effect);
        return effect;
    }

    protected LootEffect setAmplifier(int min, int max) {
        this.amplifierMin = min;
        this.amplifierMax = max;
        return this;
    }

    private int getAmplifier(Random rand) {
        return MathHelper.func_76136_a((Random)rand, (int)this.amplifierMin, (int)this.amplifierMax);
    }

    public String getActionStatus(ItemStack stack) {
        String statusString = "";
        if (this.getAction() != null) {
            statusString = this.getAction().getStatusString(stack);
        }
        return statusString;
    }

    public String getAmplifierString(ItemStack stack, String effectId) {
        return this.getAmplifierString(stack, effectId, 0);
    }

    public String getAmplifierString(ItemStack stack, String effectId, int add) {
        return TextFormatting.BOLD + "" + (LootEffect.getAmplifierFromStack(stack, effectId) + add) + "" + TextFormatting.RESET + "" + (this.getType() == EffectType.PASSIVE ? TextFormatting.GREEN : TextFormatting.GOLD) + "";
    }

    public static enum EffectType {
        ACTIVE(TextFormatting.GOLD),
        PASSIVE(TextFormatting.GREEN),
        USE(TextFormatting.AQUA);

        private TextFormatting color;

        private EffectType(TextFormatting color) {
            this.color = color;
        }

        public TextFormatting getColor() {
            return this.color;
        }

        public boolean equals(EffectType type) {
            return type == this;
        }
    }
}

