/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.loot.effects;

import binary404.mystictools.common.core.ConfigHandler;
import binary404.mystictools.common.loot.LootNbtHelper;
import binary404.mystictools.common.loot.LootSet;
import binary404.mystictools.common.loot.effects.IEffect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.TextFormatting;

public class PotionEffect
implements IEffect {
    public static final Map<String, PotionEffect> REGISTRY = new HashMap<String, PotionEffect>();
    public static PotionEffect WITHERING;
    public static PotionEffect SLOWNESS;
    public static PotionEffect POISON;
    public static PotionEffect WEAKNESS;
    public static PotionEffect BLINDNESS;
    public static PotionEffect REGENERATION;
    public static PotionEffect SPEED;
    public static PotionEffect HASTE;
    public static PotionEffect RESISTANCE;
    public static PotionEffect FIRE_RESISTANCE;
    private final PotionType effectType;
    private String id;
    private Effect effect;
    private List<LootSet.LootSetType> applyToItems = new ArrayList<LootSet.LootSetType>();
    private int durationMin = 100;
    private int durationMax = 300;
    private int amplifierMin = 0;
    private int amplifierMax = 0;

    public static void init() {
        if (((Boolean)ConfigHandler.COMMON.enableWither.get()).booleanValue()) {
            WITHERING = PotionEffect.create("wither", PotionType.TARGET, Effects.field_82731_v).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
        }
        if (((Boolean)ConfigHandler.COMMON.enableSlowness.get()).booleanValue()) {
            SLOWNESS = PotionEffect.create("slowness", PotionType.TARGET, Effects.field_76421_d).setAmplifier(1, 5).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
        }
        if (((Boolean)ConfigHandler.COMMON.enablePoison.get()).booleanValue()) {
            POISON = PotionEffect.create("poison", PotionType.TARGET, Effects.field_76436_u).setAmplifier(0, 3).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
        }
        if (((Boolean)ConfigHandler.COMMON.enableWeakness.get()).booleanValue()) {
            WEAKNESS = PotionEffect.create("weakness", PotionType.TARGET, Effects.field_76437_t).setAmplifier(0, 3).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
        }
        if (((Boolean)ConfigHandler.COMMON.enableBlindness.get()).booleanValue()) {
            BLINDNESS = PotionEffect.create("blindness", PotionType.TARGET, Effects.field_76440_q).setAmplifier(0, 3).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
        }
        if (((Boolean)ConfigHandler.COMMON.enableRegeneration.get()).booleanValue()) {
            REGENERATION = PotionEffect.create("regeneration", PotionType.USER, Effects.field_76428_l).setAmplifier(0, 2).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.PICKAXE, LootSet.LootSetType.AXE, LootSet.LootSetType.SHOVEL);
        }
        if (((Boolean)ConfigHandler.COMMON.enableSpeed.get()).booleanValue()) {
            SPEED = PotionEffect.create("speed", PotionType.USER, Effects.field_76424_c).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.PICKAXE, LootSet.LootSetType.AXE, LootSet.LootSetType.SHOVEL);
        }
        if (((Boolean)ConfigHandler.COMMON.enableHaste.get()).booleanValue()) {
            HASTE = PotionEffect.create("haste", PotionType.USER, Effects.field_76422_e).setAmplifier(2, 4).setItemTypes(LootSet.LootSetType.AXE, LootSet.LootSetType.PICKAXE, LootSet.LootSetType.SHOVEL);
        }
        if (((Boolean)ConfigHandler.COMMON.enableResistance.get()).booleanValue()) {
            RESISTANCE = PotionEffect.create("resistance", PotionType.USER, Effects.field_76429_m).setAmplifier(0, 2).setItemTypes(LootSet.LootSetType.PICKAXE, LootSet.LootSetType.AXE, LootSet.LootSetType.SHOVEL, LootSet.LootSetType.SWORD);
        }
        if (((Boolean)ConfigHandler.COMMON.enableFireResistance.get()).booleanValue()) {
            FIRE_RESISTANCE = PotionEffect.create("fire_resistance", PotionType.USER, Effects.field_76426_n).setAmplifier(0, 0).setItemTypes(LootSet.LootSetType.PICKAXE, LootSet.LootSetType.AXE, LootSet.LootSetType.SHOVEL, LootSet.LootSetType.SWORD);
        }
    }

    private PotionEffect(PotionType type) {
        this.effectType = type;
    }

    public PotionType getType() {
        return this.effectType;
    }

    public boolean applyToItemType(LootSet.LootSetType type) {
        return this.applyToItems.contains((Object)type);
    }

    protected PotionEffect setItemTypes(LootSet.LootSetType ... itemTypes) {
        for (LootSet.LootSetType type : itemTypes) {
            this.applyToItems.add(type);
        }
        return this;
    }

    @Nullable
    public static PotionEffect getById(String id) {
        PotionEffect effect = REGISTRY.get(id);
        return effect;
    }

    public String getId() {
        return this.id;
    }

    public CompoundNBT getNbt(Random rand) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("id", this.getId());
        tag.func_74768_a("duration", this.getDuration(rand));
        tag.func_74768_a("amplifier", this.getAmplifier(rand));
        return tag;
    }

    public static int getDurationFromStack(ItemStack stack, String effectId) {
        int duration = 0;
        ListNBT effectTagList = LootNbtHelper.getLootTagList(stack, "potionList");
        int count = effectTagList.size();
        for (int i = 0; i < count; ++i) {
            CompoundNBT e = effectTagList.func_150305_b(i);
            if (!e.func_74779_i("id").contains(effectId)) continue;
            duration = e.func_74762_e("duration");
        }
        return duration;
    }

    public static int getAmplifierFromStack(ItemStack stack, String effectId) {
        int amplifier = 0;
        ListNBT effectTagList = LootNbtHelper.getLootTagList(stack, "effectList");
        int count = effectTagList.size();
        for (int i = 0; i < count; ++i) {
            CompoundNBT e = effectTagList.func_150305_b(i);
            if (!e.func_74779_i("id").contains(effectId)) continue;
            amplifier = e.func_74762_e("amplifier");
        }
        return amplifier;
    }

    public static List<PotionEffect> getPotionlist(ItemStack stack) {
        ArrayList<PotionEffect> list = new ArrayList<PotionEffect>();
        ListNBT effectTagList = LootNbtHelper.getLootTagList(stack, "potionList");
        int count = effectTagList.size();
        for (int i = 0; i < count; ++i) {
            CompoundNBT e = effectTagList.func_150305_b(i);
            list.add(PotionEffect.getById(e.func_74779_i("id")));
        }
        return list;
    }

    protected static PotionEffect create(String id, PotionType type, Effect effect) {
        PotionEffect weaponEffect = new PotionEffect(type);
        weaponEffect.id = id;
        weaponEffect.effect = effect;
        REGISTRY.put(id, weaponEffect);
        return weaponEffect;
    }

    protected PotionEffect setDuration(int min, int max) {
        this.durationMin = min * 100;
        this.durationMax = max * 100;
        return this;
    }

    protected PotionEffect setAmplifier(int min, int max) {
        this.amplifierMin = min;
        this.amplifierMax = max;
        return this;
    }

    private int getDuration(Random rand) {
        int duration = this.durationMin;
        if (duration < this.durationMax) {
            duration += rand.nextInt(this.durationMax - duration + 1);
        }
        return duration;
    }

    private int getAmplifier(Random rand) {
        int amplifier = this.amplifierMin;
        if (amplifier < this.amplifierMax) {
            amplifier += rand.nextInt(this.amplifierMax - amplifier + 1);
        }
        return amplifier;
    }

    @Nullable
    public EffectInstance getPotionEffect(int duration, int amplifier) {
        if (this.effect == null) {
            return null;
        }
        EffectInstance weaponEffect = new EffectInstance(this.effect, duration, amplifier, true, false);
        return weaponEffect;
    }

    public void onHit(int duration, int amplifier, LivingEntity target, LivingEntity attacker) {
        EffectInstance instance = this.getPotionEffect(duration, amplifier);
        if (instance != null) {
            if (this.getType() == PotionType.USER) {
                attacker.func_195064_c(instance);
            } else {
                target.func_195064_c(instance);
            }
        }
    }

    public String getAmplifierString(ItemStack stack, String effectId) {
        return this.getAmplifierString(stack, effectId, 0);
    }

    public String getAmplifierString(ItemStack stack, String effectId, int add) {
        return TextFormatting.BOLD + "" + (PotionEffect.getAmplifierFromStack(stack, effectId) + add) + "" + TextFormatting.RESET + "" + (this.getType() == PotionType.USER ? TextFormatting.GOLD : TextFormatting.RED) + "";
    }

    public String getDurationString(ItemStack stack, String effectId) {
        return TextFormatting.BOLD + "" + PotionEffect.getDurationFromStack(stack, effectId) / 100 + "" + TextFormatting.RESET + "" + TextFormatting.GREEN + "";
    }

    public static enum PotionType {
        USER(TextFormatting.GOLD),
        TARGET(TextFormatting.RED);

        private TextFormatting color;

        private PotionType(TextFormatting color) {
            this.color = color;
        }

        public TextFormatting getColor() {
            return this.color;
        }

        public boolean equals(PotionType type) {
            return type == this;
        }
    }
}

