/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.loot.effects.effect;

import binary404.mystictools.common.loot.LootNbtHelper;
import binary404.mystictools.common.loot.effects.IEffectAction;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class LootEffectVoid
implements IEffectAction {
    @Override
    public void toggleAction(PlayerEntity player, ItemStack stack) {
        boolean active = false;
        if (stack == null) {
            return;
        }
        active = !LootNbtHelper.getLootBooleanValue(stack, "effect_active");
        LootNbtHelper.setLootBooleanValue(stack, "effect_active", active);
    }

    @Override
    public void handleHarvest(PlayerEntity player, ItemStack stack, List<ItemStack> drops, BlockPos pos) {
        boolean effectActive = LootNbtHelper.getLootBooleanValue(stack, "effect_active");
        if (!effectActive) {
            return;
        }
        drops.clear();
    }

    @Override
    public ITextComponent modificationResponseMessage(PlayerEntity player, ItemStack stack) {
        boolean active = LootNbtHelper.getLootBooleanValue(stack, "effect_active");
        String message = "[Mystic Tools]: ";
        message = message + stack.func_200301_q().getString();
        message = message + TextFormatting.RESET;
        message = message + "'s ";
        message = message + I18n.func_135052_a((String)"weaponeffect.void.name", (Object[])new Object[0]);
        message = message + ", has been set to: ";
        message = message + active;
        return new StringTextComponent(message);
    }

    @Override
    public void handleUpdate(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
    }

    @Override
    public String getStatusString(ItemStack stack) {
        String status = "[Off]";
        if (LootNbtHelper.getLootBooleanValue(stack, "effect_active")) {
            status = "[On]";
        }
        return status;
    }

    @Override
    public ActionResult<ItemStack> handleUse(ActionResult<ItemStack> defaultAction, World world, PlayerEntity player, Hand hand) {
        return defaultAction;
    }
}

