/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.network;

import binary404.mystictools.common.network.PacketOpenCrateFX;
import binary404.mystictools.common.network.PacketSparkle;
import binary404.mystictools.common.network.PacketToggle;
import binary404.mystictools.common.network.PacketUpgrader;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL = "6";
    public static final SimpleChannel HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("mystictools", "channel"), () -> "6", "6"::equals, "6"::equals);

    public static void init() {
        int id = 0;
        HANDLER.registerMessage(id++, PacketToggle.class, PacketToggle::encode, PacketToggle::decode, PacketToggle::handle);
        HANDLER.registerMessage(id++, PacketOpenCrateFX.class, PacketOpenCrateFX::encode, PacketOpenCrateFX::decode, PacketOpenCrateFX::handle);
        HANDLER.registerMessage(id++, PacketSparkle.class, PacketSparkle::encode, PacketSparkle::decode, PacketSparkle::handle);
        HANDLER.registerMessage(id++, PacketUpgrader.class, PacketUpgrader::encode, PacketUpgrader::decode, PacketUpgrader::handle);
    }

    public static void sendToNearby(World world, BlockPos pos, Object toSend) {
        if (world instanceof ServerWorld) {
            ServerWorld ws = (ServerWorld)world;
            ws.func_72863_F().field_217237_a.func_219097_a(new ChunkPos(pos), false).filter(p -> p.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < 4096.0).forEach(p -> HANDLER.send(PacketDistributor.PLAYER.with(() -> p), toSend));
        }
    }

    public static void sendToNearby(World world, Entity e, Object toSend) {
        NetworkHandler.sendToNearby(world, new BlockPos(e), toSend);
    }

    public static void sendTo(ServerPlayerEntity playerMP, Object toSend) {
        HANDLER.sendTo(toSend, playerMP.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendNonLocal(ServerPlayerEntity playerMP, Object toSend) {
        if (playerMP.field_71133_b.func_71262_S() || !playerMP.func_146103_bH().getName().equals(playerMP.field_71133_b.func_71214_G())) {
            NetworkHandler.sendTo(playerMP, toSend);
        }
    }

    public static void sendToServer(Object msg) {
        HANDLER.sendToServer(msg);
    }
}

