/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.blocks;

import binary404.mystictools.common.core.UniqueHandler;
import binary404.mystictools.common.items.ILootItem;
import binary404.mystictools.common.items.ModItems;
import binary404.mystictools.common.loot.LootNbtHelper;
import binary404.mystictools.common.loot.LootRarity;
import binary404.mystictools.common.network.NetworkHandler;
import binary404.mystictools.common.network.PacketFX;
import binary404.mystictools.common.tile.TileEntityCauldron;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockCauldron
extends Block {
    private static final VoxelShape INSIDE = BlockCauldron.func_208617_a((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_216384_a((VoxelShape)BlockCauldron.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{BlockCauldron.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), BlockCauldron.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (IBooleanFunction)IBooleanFunction.field_223234_e_);

    public BlockCauldron(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        ItemEntity itemEntity;
        Item item;
        if (!worldIn.field_72995_K && entityIn instanceof ItemEntity && (item = (itemEntity = (ItemEntity)entityIn).func_92059_d().func_77973_b()) instanceof ILootItem) {
            ItemStack stack;
            LootRarity rarity = LootRarity.fromId(LootNbtHelper.getLootStringValue(itemEntity.func_92059_d(), "rarity"));
            if (rarity == LootRarity.COMMON) {
                stack = new ItemStack((IItemProvider)ModItems.shard, MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)3, (int)7));
            } else if (rarity == LootRarity.UNCOMMON) {
                stack = new ItemStack((IItemProvider)ModItems.shard, MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)6, (int)10));
            } else if (rarity == LootRarity.RARE) {
                stack = new ItemStack((IItemProvider)ModItems.shard, MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)9, (int)13));
            } else if (rarity == LootRarity.EPIC) {
                stack = new ItemStack((IItemProvider)ModItems.shard, MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)12, (int)15));
            } else if (rarity == LootRarity.UNIQUE) {
                stack = new ItemStack((IItemProvider)ModItems.shard, MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)15, (int)18));
                if (worldIn instanceof ServerWorld) {
                    UniqueHandler.resetUniqueItems((ServerWorld)worldIn);
                }
            } else {
                stack = new ItemStack((IItemProvider)ModItems.shard, MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)3, (int)7));
            }
            NetworkHandler.sendToNearby(worldIn, entityIn, (Object)new PacketFX(entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), 0));
            itemEntity.func_92058_a(stack);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityCauldron();
    }
}

