/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.core;

import binary404.mystictools.common.core.ConfigHandler;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mystictools")
public class ChestHelper {
    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        String file;
        String prefix = "chests/";
        String name = event.getName().func_110623_a();
        if (name.startsWith(prefix)) {
            file = "inject";
            event.getTable().addPool(ChestHelper.getInjectPool(file));
        } else if (name.startsWith("minecraft:entities/") && ((Boolean)ConfigHandler.COMMON.enableMobDropCrate.get()).booleanValue()) {
            file = "entity";
            event.getTable().addPool(ChestHelper.getInjectPool(file));
        }
        prefix = "minecraft:chests/";
        name = event.getName().toString();
        if (name.startsWith(prefix)) {
            String type = name.substring(name.indexOf(prefix) + prefix.length());
            String[] common = new String[]{"abandoned_mineshaft", "jungle_temple", "spawn_bonus_chest", "village_blacksmith"};
            String[] uncommon = new String[]{"desert_temple", "simple_dungeon", "stronghold_corridor", "abandoned_mineshaft"};
            String[] rare = new String[]{"simple_dungeon", "stronghold_corridor", "nether_bridge"};
            String[] epic = new String[]{"nether_bridge", "stronghold_library"};
            String[] unique = new String[]{"end_city_treasure"};
            if (type.equals(common[0]) || type.equals(common[1]) || type.equals(common[2]) || type.equals(common[3])) {
                event.getTable().addPool(ChestHelper.getInjectPool("common"));
            }
            if (type.equals(uncommon[0]) || type.equals(uncommon[1]) || type.equals(uncommon[2]) || type.equals(uncommon[3])) {
                event.getTable().addPool(ChestHelper.getInjectPool("uncommon"));
            }
            if (type.equals(rare[0]) || type.equals(rare[1]) || type.equals(rare[2])) {
                event.getTable().addPool(ChestHelper.getInjectPool("rare"));
            }
            if (type.equals(epic[0]) || type.equals(epic[1])) {
                event.getTable().addPool(ChestHelper.getInjectPool("epic"));
            }
            if (type.equals(unique[0])) {
                event.getTable().addPool(ChestHelper.getInjectPool("unique"));
            }
        }
    }

    public static LootPool getInjectPool(String entryName) {
        return LootPool.func_216096_a().func_216045_a(ChestHelper.getInjectEntry(entryName, (Integer)ConfigHandler.COMMON.lootCrateWeight.get())).bonusRolls((float)((Integer)ConfigHandler.COMMON.lootCrateMinRolls.get()).intValue(), (float)((Integer)ConfigHandler.COMMON.lootCrateMaxRolls.get()).intValue()).name("mystictools_inject" + entryName).func_216044_b();
    }

    private static LootEntry.Builder getInjectEntry(String name, int weight) {
        ResourceLocation table = new ResourceLocation("mystictools", "inject/" + name);
        return TableLootEntry.func_216171_a((ResourceLocation)table).func_216086_a(weight);
    }
}

