/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.core;

import binary404.mystictools.common.items.ModItems;
import binary404.mystictools.common.loot.LootItemHelper;
import binary404.mystictools.common.loot.effects.LootEffect;
import binary404.mystictools.common.loot.effects.UniqueEffect;
import binary404.mystictools.common.network.NetworkHandler;
import binary404.mystictools.common.network.PacketSparkle;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mystictools")
public class EntityHandler {
    @SubscribeEvent
    public static void arrowHit(ProjectileImpactEvent.Arrow event) {
        CompoundNBT compound;
        String id;
        UniqueEffect effect;
        if (event.getArrow().getPersistentData().func_74764_b("unique") && (effect = UniqueEffect.getById(id = (compound = event.getArrow().getPersistentData().func_74775_l("unique")).func_74779_i("id"))) != null) {
            Entity entity = event.getArrow().field_70170_p.func_73045_a(event.getArrow().field_234610_c_);
            effect.arrowImpact(entity, (Entity)event.getArrow());
        }
    }

    @SubscribeEvent
    public static void sleepingCheck(SleepingLocationCheckEvent event) {
        ItemStack stack;
        if (event.getEntityLiving().func_70608_bn() && !event.getEntityLiving().field_70170_p.func_72935_r() && LootItemHelper.hasEffect(stack = event.getEntityLiving().func_184614_ca(), LootEffect.SLEEP)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingDamageEvent event) {
        Entity sourceEntity = event.getSource().func_76346_g();
        if (sourceEntity != null && !sourceEntity.field_70170_p.field_72995_K) {
            ItemStack stack;
            List<LootEffect> effects;
            PlayerEntity player;
            if (sourceEntity instanceof PlayerEntity && (player = (PlayerEntity)sourceEntity).func_184614_ca().func_77973_b() == ModItems.loot_sword && (effects = LootEffect.getEffectList(stack = player.func_184614_ca())).contains(LootEffect.getById("leech"))) {
                float damageInflicted = Math.min(event.getAmount(), event.getEntityLiving().func_110143_aJ());
                int amplifier = LootEffect.getAmplifierFromStack(stack, "leech");
                float leech = damageInflicted * ((float)amplifier / 100.0f);
                player.func_70691_i(leech);
                NetworkHandler.sendToNearby(player.field_70170_p, (Entity)player, (Object)new PacketSparkle(event.getEntityLiving().func_226277_ct_() + 0.5, event.getEntityLiving().func_226278_cu_() + 0.5, event.getEntityLiving().func_226281_cx_() + 0.5, 0.92f, 0.0f, 0.08f));
            }
            if (event.getEntityLiving() instanceof PlayerEntity && event.getSource().func_76346_g() instanceof LivingEntity) {
                player = (PlayerEntity)event.getEntityLiving();
                for (ItemStack stack2 : player.field_71071_by.field_70460_b) {
                    List<LootEffect> effects2 = LootEffect.getEffectList(stack2);
                    for (LootEffect effect : effects2) {
                        if (effect.getAction() == null) continue;
                        effect.getAction().handleArmorHit(stack2, (LivingEntity)player, (LivingEntity)event.getSource().func_76346_g());
                    }
                }
            }
            if (event.getEntityLiving() instanceof PlayerEntity) {
                PlayerEntity playerEntity = (PlayerEntity)event.getEntityLiving();
                for (ItemStack stack2 : playerEntity.field_71071_by.field_70460_b) {
                    List<LootEffect> effects3 = LootEffect.getEffectList(stack2);
                    if (effects3.contains(LootEffect.REFLECT)) {
                        float damage = event.getAmount() / 2.0f;
                        event.setAmount(damage);
                        if (event.getSource().func_76346_g() != null) {
                            event.getSource().func_76346_g().func_70097_a(new DamageSource("reflect"), damage);
                        }
                    }
                    if (!effects3.contains(LootEffect.PARRY)) continue;
                    int chance = LootEffect.getAmplifierFromStack(stack2, LootEffect.PARRY.getId());
                    if (playerEntity.field_70170_p.field_73012_v.nextInt(100) > chance) continue;
                    playerEntity.field_70170_p.func_184148_a(null, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_187767_eL, SoundCategory.MASTER, 1.0f, 1.0f);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onOrbPickup(PlayerXpEvent.PickupXp event) {
        PlayerEntity player = event.getPlayer();
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            List<LootEffect> effects = LootEffect.getEffectList(stack);
            if (!effects.contains(LootEffect.INSIGHT)) continue;
            int level = LootEffect.getAmplifierFromStack(stack, LootEffect.INSIGHT.getId());
            ExperienceOrbEntity orb = event.getOrb();
            orb.field_70530_e *= 1 + level;
        }
    }
}

