/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.core;

import binary404.mystictools.common.core.util.LootSetArgument;
import binary404.mystictools.common.core.util.LootSetInput;
import binary404.mystictools.common.core.util.RarityArgument;
import binary404.mystictools.common.core.util.RarityInput;
import binary404.mystictools.common.loot.LootItemHelper;
import binary404.mystictools.common.loot.LootSet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Random;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class GenerateLootCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder commandBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"generateLoot").requires(s -> s.func_197034_c(3))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"rarity", (ArgumentType)RarityArgument.rarity()).executes(p -> GenerateLootCommand.generateItemFromRarity((CommandSource)p.getSource(), RarityArgument.getRarity(p, "rarity"), EntityArgument.func_197090_e((CommandContext)p, (String)"targets")))).then(Commands.func_197056_a((String)"set", (ArgumentType)LootSetArgument.set()).executes(p -> GenerateLootCommand.generateItemFromRarityAndSet((CommandSource)p.getSource(), RarityArgument.getRarity(p, "rarity"), LootSetArgument.getType(p, "set"), EntityArgument.func_197090_e((CommandContext)p, (String)"targets"))))));
        LiteralCommandNode command = dispatcher.register(commandBuilder);
    }

    private static int generateItemFromRarity(CommandSource source, RarityInput input, Collection<ServerPlayerEntity> targets) {
        for (ServerPlayerEntity player : targets) {
            ItemEntity itemEntity;
            boolean flag;
            Random random = new Random();
            ItemStack itemStack = LootItemHelper.getRandomLoot(random);
            LootSet.LootSetType type = LootItemHelper.getItemType(itemStack.func_77973_b());
            if (type == null) {
                type = LootSet.LootSetType.SWORD;
            }
            if ((flag = player.field_71071_by.func_70441_a(itemStack = LootItemHelper.generateLoot(input.getRarity(), type, itemStack))) && itemStack.func_190926_b()) {
                itemStack.func_190920_e(1);
                itemEntity = player.func_71019_a(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.func_174870_v();
                }
                player.field_71069_bz.func_75142_b();
                continue;
            }
            itemEntity = player.func_71019_a(itemStack, false);
            if (itemEntity == null) continue;
            itemEntity.func_174868_q();
            itemEntity.func_200217_b(player.func_110124_au());
        }
        return targets.size();
    }

    private static int generateItemFromRarityAndSet(CommandSource source, RarityInput input, LootSetInput set, Collection<ServerPlayerEntity> targets) {
        for (ServerPlayerEntity player : targets) {
            ItemEntity itemEntity;
            Random random = new Random();
            LootSet.LootSetType type = set.getType();
            if (type == null) {
                type = LootSet.LootSetType.SWORD;
            }
            ItemStack itemStack = new ItemStack((IItemProvider)type.getItem());
            itemStack = LootItemHelper.generateLoot(input.getRarity(), type, itemStack);
            boolean flag = player.field_71071_by.func_70441_a(itemStack);
            if (flag && itemStack.func_190926_b()) {
                itemStack.func_190920_e(1);
                itemEntity = player.func_71019_a(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.func_174870_v();
                }
                player.field_71069_bz.func_75142_b();
                continue;
            }
            itemEntity = player.func_71019_a(itemStack, false);
            if (itemEntity == null) continue;
            itemEntity.func_174868_q();
            itemEntity.func_200217_b(player.func_110124_au());
        }
        return targets.size();
    }
}

