/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.core;

import binary404.mystictools.common.core.ConfigHandler;
import binary404.mystictools.common.items.ModItems;
import binary404.mystictools.common.loot.LootItemHelper;
import binary404.mystictools.common.loot.LootRarity;
import binary404.mystictools.common.loot.LootSet;
import binary404.mystictools.common.loot.effects.UniqueEffect;
import binary404.mystictools.common.world.UniqueSave;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;

public class UniqueHandler {
    public static void generateUniqueItems(ServerWorld world) {
        UniqueSave.forWorld((ServerWorld)world).uniques.clear();
        int generated = 0;
        while (generated <= (Integer)ConfigHandler.COMMON.uniqueCount.get()) {
            ItemStack stack = LootItemHelper.getRandomLoot(new Random());
            UniqueEffect effect = LootItemHelper.getRandomUnique(new Random(), LootItemHelper.getItemType(stack.func_77973_b()));
            if (stack.func_77973_b().getRegistryName() == null) {
                stack = new ItemStack((IItemProvider)ModItems.loot_pickaxe);
            }
            if (effect == null) continue;
            UniqueSave.UniqueInfo info = new UniqueSave.UniqueInfo(stack.func_77973_b(), effect, false);
            UniqueSave.forWorld((ServerWorld)world).uniques.add(info);
            ++generated;
        }
        UniqueSave.forWorld(world).func_76185_a();
    }

    public static void resetUniqueItems(ServerWorld world) {
        UniqueSave.forWorld((ServerWorld)world).uniques.clear();
        UniqueSave.forWorld(world).func_76185_a();
        UniqueHandler.generateUniqueItems(world);
    }

    public static ItemStack getRandomUniqueItem(ServerWorld world, PlayerEntity target) {
        UniqueSave save = UniqueSave.forWorld(world);
        int randomInt = new Random().nextInt(save.uniques.size());
        UniqueSave.UniqueInfo info = save.uniques.get(randomInt);
        if (info.found) {
            save.uniques.set(randomInt, info);
            save.func_76185_a();
            return LootItemHelper.generateLoot(LootRarity.EPIC, LootItemHelper.getItemType(info.item), new ItemStack((IItemProvider)info.item));
        }
        LootSet.LootSetType type = LootItemHelper.getItemType(info.item);
        ItemStack loot = LootItemHelper.generateLoot(LootRarity.UNIQUE, type, new ItemStack((IItemProvider)info.item));
        loot.func_77978_p().func_74775_l("mysticTools").func_218657_a("unique", (INBT)info.effect.getNbt());
        info.found = true;
        save.uniques.set(randomInt, info);
        save.func_76185_a();
        int found = 0;
        for (UniqueSave.UniqueInfo unique : save.uniques) {
            if (!unique.found) continue;
            ++found;
        }
        target.func_146105_b((ITextComponent)new StringTextComponent("Unique Found! (" + found + "/" + ConfigHandler.COMMON.uniqueCount.get() + ") found"), true);
        return loot;
    }
}

