/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.core;

import binary404.mystictools.common.blocks.ModBlocks;
import binary404.mystictools.common.core.RegistryHelper;
import binary404.mystictools.common.core.util.Utils;
import binary404.mystictools.common.items.ModItems;
import binary404.mystictools.mixin.HeroGiftTaskAccess;
import binary404.mystictools.mixin.PoITypeAccess;
import binary404.mystictools.mixin.SingleJigsawAccess;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VillagerHandler {
    public static PointOfInterestType POI_CORROSION_CAULDRON;
    public static VillagerProfession MERCHANT;

    public static void init() {
        PlainsVillagePools.func_214744_a();
        SnowyVillagePools.func_214746_a();
        SavannaVillagePools.func_214745_a();
        DesertVillagePools.func_222739_a();
        TaigaVillagePools.func_214806_a();
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            VillagerHandler.addToPool(new ResourceLocation("village/" + biome + "/houses"), VillagerHandler.rl("village/houses/merchant"), 6);
        }
        HeroGiftTaskAccess.getGifts().put(MERCHANT, VillagerHandler.rl("gameplay/hero_of_the_village/merchant"));
    }

    private static JigsawPiece createWorkstation(String name) {
        return SingleJigsawAccess.construct((Either<ResourceLocation, Template>)Either.left((Object)VillagerHandler.rl(name)), () -> ProcessorLists.field_244101_a, JigsawPattern.PlacementBehaviour.RIGID);
    }

    private static void addToPool(ResourceLocation pool, ResourceLocation toAdd, int weight) {
        JigsawPattern old = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(pool);
        List shuffled = old != null ? old.func_214943_b(new Random(0L)) : ImmutableList.of();
        Object2IntLinkedOpenHashMap newPieces = new Object2IntLinkedOpenHashMap();
        Iterator iterator = shuffled.iterator();
        while (iterator.hasNext()) {
            JigsawPiece p = (JigsawPiece)iterator.next();
            newPieces.computeInt((Object)p, (pTemp, i) -> (i == null ? 0 : i) + 1);
        }
        newPieces.put((Object)SingleJigsawAccess.construct((Either<ResourceLocation, Template>)Either.left((Object)toAdd), () -> ProcessorLists.field_244101_a, JigsawPattern.PlacementBehaviour.RIGID), weight);
        List newPieceList = newPieces.object2IntEntrySet().stream().map(e -> Pair.of((Object)e.getKey(), (Object)e.getIntValue())).collect(Collectors.toList());
        ResourceLocation name = old.func_214947_b();
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243656_h, (ResourceLocation)pool, (Object)new JigsawPattern(pool, name, newPieceList));
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation("mystictools", path);
    }

    @SubscribeEvent
    public static void registerPOI(RegistryEvent.Register<PointOfInterestType> event) {
        POI_CORROSION_CAULDRON = (PointOfInterestType)RegistryHelper.register(event.getRegistry(), VillagerHandler.createPOI("corrosion_cauldron", ModBlocks.cauldron.func_176223_P()), "corrosion_cauldron");
    }

    @SubscribeEvent
    public static void registerProf(RegistryEvent.Register<VillagerProfession> event) {
        MERCHANT = (VillagerProfession)RegistryHelper.register(event.getRegistry(), VillagerHandler.createProf(new ResourceLocation("mystictools", "merchant"), POI_CORROSION_CAULDRON, SoundEvents.field_187917_gq), "merchant");
    }

    private static PointOfInterestType createPOI(String name, BlockState blockState) {
        PointOfInterestType type = new PointOfInterestType("mystictools:" + name, (Set)ImmutableSet.of((Object)blockState), 1, 1);
        PoITypeAccess.callRegisterBlockStates(type);
        return type;
    }

    private static VillagerProfession createProf(ResourceLocation name, PointOfInterestType poi, SoundEvent sound) {
        return new VillagerProfession(name.toString(), poi, ImmutableSet.builder().build(), ImmutableSet.builder().build(), sound);
    }

    private static class PriceInterval {
        private final int min;
        private final int max;

        private PriceInterval(int min, int max) {
            this.min = min;
            this.max = max;
        }

        int getPrice(Random rand) {
            return this.min >= this.max ? this.min : this.min + rand.nextInt(this.max - this.min + 1);
        }
    }

    private static class ItemsForEmeraldBlock
    implements VillagerTrades.ITrade {
        public ItemStack sellingItem;
        public PriceInterval priceInfo;
        final int maxUses;
        final int xp;
        final float priceMult;

        public ItemsForEmeraldBlock(IItemProvider item, PriceInterval priceInfo, int maxUses, int xp, float priceMult) {
            this(new ItemStack(item), priceInfo, maxUses, xp, priceMult);
        }

        public ItemsForEmeraldBlock(ItemStack par1Item, PriceInterval priceInfo, int maxUses, int xp, float priceMult) {
            this.sellingItem = par1Item;
            this.priceInfo = priceInfo;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMult = priceMult;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack selling;
            ItemStack buying;
            int i = 1;
            if (this.priceInfo != null) {
                i = this.priceInfo.getPrice(rand);
            }
            if (i < 0) {
                buying = new ItemStack((IItemProvider)Items.field_221739_dF);
                selling = Utils.copyStackWithAmount(this.sellingItem, -i);
            } else {
                buying = new ItemStack((IItemProvider)Items.field_221739_dF, i);
                selling = this.sellingItem;
            }
            return new MerchantOffer(buying, selling, this.maxUses, this.xp, this.priceMult);
        }
    }

    private static class ItemsForEmerald
    implements VillagerTrades.ITrade {
        public ItemStack sellingItem;
        public PriceInterval priceInfo;
        final int maxUses;
        final int xp;
        final float priceMult;

        public ItemsForEmerald(IItemProvider item, PriceInterval priceInfo, int maxUses, int xp, float priceMult) {
            this(new ItemStack(item), priceInfo, maxUses, xp, priceMult);
        }

        public ItemsForEmerald(ItemStack par1Item, PriceInterval priceInfo, int maxUses, int xp, float priceMult) {
            this.sellingItem = par1Item;
            this.priceInfo = priceInfo;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMult = priceMult;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack selling;
            ItemStack buying;
            int i = 1;
            if (this.priceInfo != null) {
                i = this.priceInfo.getPrice(rand);
            }
            if (i < 0) {
                buying = new ItemStack((IItemProvider)Items.field_151166_bC);
                selling = Utils.copyStackWithAmount(this.sellingItem, -i);
            } else {
                buying = new ItemStack((IItemProvider)Items.field_151166_bC, i);
                selling = this.sellingItem;
            }
            return new MerchantOffer(buying, selling, this.maxUses, this.xp, this.priceMult);
        }
    }

    private static class EmeraldForItems
    implements VillagerTrades.ITrade {
        public ItemStack buyingItem;
        public PriceInterval buyAmounts;
        final int maxUses;
        final int xp;
        public PriceInterval emeralds;

        public EmeraldForItems(@Nonnull ItemStack item, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this(item, buyAmounts, new PriceInterval(1, 1), maxUses, xp);
        }

        public EmeraldForItems(@Nonnull ItemStack item, @Nonnull PriceInterval buyAmounts, PriceInterval emeralds, int maxUses, int xp) {
            this.buyingItem = item;
            this.buyAmounts = buyAmounts;
            this.maxUses = maxUses;
            this.xp = xp;
            this.emeralds = emeralds;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(Utils.copyStackWithAmount(this.buyingItem, this.buyAmounts.getPrice(rand)), new ItemStack((IItemProvider)Items.field_151166_bC, this.emeralds.getPrice(rand)), this.maxUses, this.xp, 0.05f);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Trades {
        public static final ResourceLocation MERCHANT = new ResourceLocation("mystictools", "merchant");

        @SubscribeEvent
        public static void registerTrades(VillagerTradesEvent event) {
            Int2ObjectMap trades = event.getTrades();
            if (MERCHANT.equals((Object)event.getType().getRegistryName())) {
                ((List)trades.get(1)).add(new EmeraldForItems(new ItemStack((IItemProvider)ModItems.shard), new PriceInterval(4, 26), 4, 2));
                ((List)trades.get(1)).add(new EmeraldForItems(new ItemStack((IItemProvider)ModItems.loot_case), new PriceInterval(1, 4), new PriceInterval(4, 10), 8, 1));
                ((List)trades.get(1)).add(new ItemsForEmerald(new ItemStack((IItemProvider)ModItems.loot_case), new PriceInterval(10, 24), 4, 1, 0.05f));
                ((List)trades.get(1)).add(new EmeraldForItems(new ItemStack((IItemProvider)ModItems.loot_shovel), new PriceInterval(1, 1), 8, 2));
                ((List)trades.get(1)).add(new EmeraldForItems(new ItemStack((IItemProvider)ModItems.loot_axe), new PriceInterval(1, 1), 8, 2));
                ((List)trades.get(1)).add(new ItemsForEmerald(new ItemStack((IItemProvider)ModItems.common_case), new PriceInterval(4, 10), 8, 1, 0.008f));
                ((List)trades.get(1)).add(new ItemsForEmerald(new ItemStack((IItemProvider)ModItems.uncommon_case), new PriceInterval(10, 24), 8, 1, 0.006f));
                ((List)trades.get(2)).add(new EmeraldForItems(new ItemStack((IItemProvider)ModItems.loot_pickaxe), new PriceInterval(1, 1), 8, 4));
                ((List)trades.get(2)).add(new EmeraldForItems(new ItemStack((IItemProvider)ModItems.loot_bow), new PriceInterval(1, 1), 8, 6));
                ((List)trades.get(2)).add(new ItemsForEmerald((IItemProvider)ModItems.shovel_case, new PriceInterval(12, 38), 1, 6, 0.05f));
                ((List)trades.get(2)).add(new ItemsForEmerald((IItemProvider)ModItems.axe_case, new PriceInterval(18, 44), 1, 4, 0.05f));
                ((List)trades.get(3)).add(new ItemsForEmerald((IItemProvider)ModItems.pickaxe_case, new PriceInterval(20, 46), 1, 10, 0.05f));
                ((List)trades.get(3)).add(new ItemsForEmerald((IItemProvider)ModItems.bow_case, new PriceInterval(25, 55), 1, 7, 0.05f));
                ((List)trades.get(3)).add(new ItemsForEmerald((IItemProvider)ModItems.rare_case, new PriceInterval(20, 30), 8, 10, 0.05f));
                ((List)trades.get(4)).add(new ItemsForEmerald((IItemProvider)ModItems.sword_case, new PriceInterval(25, 58), 1, 15, 0.05f));
                ((List)trades.get(4)).add(new ItemsForEmerald((IItemProvider)ModItems.epic_case, new PriceInterval(30, 50), 8, 15, 0.04f));
                ((List)trades.get(5)).add(new ItemsForEmeraldBlock((IItemProvider)ModItems.unique_case, new PriceInterval(40, 64), 1, 30, 0.03f));
            }
        }
    }
}

