/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.core.util;

import binary404.mystictools.common.core.util.RarityInput;
import binary404.mystictools.common.core.util.RarityParser;
import binary404.mystictools.common.loot.LootRarity;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public class RarityArgument
implements ArgumentType<RarityInput> {
    private static final Collection<String> EXAMPLES = Arrays.asList("common", "rare", "uncommon");

    public static RarityArgument rarity() {
        return new RarityArgument();
    }

    public RarityInput parse(StringReader reader) throws CommandSyntaxException {
        RarityParser parser = new RarityParser(reader).parse();
        return new RarityInput(parser.getRarity());
    }

    public static <S> RarityInput getRarity(CommandContext<S> context, String name) {
        return (RarityInput)context.getArgument(name, RarityInput.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        RarityParser parser = new RarityParser(reader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return parser.fillSuggestions(builder, LootRarity.getRegistry().values());
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

