/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.core.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import org.apache.commons.lang3.ObjectUtils;

public class Utils {
    @Nonnull
    public static Optional<ItemStack> findSmeltingResult(World world, ItemStack input) {
        RecipeManager mgr = world.func_199532_z();
        Inventory inv = new Inventory(new ItemStack[]{input});
        Optional optRecipe = (Optional)ObjectUtils.firstNonNull((Object[])new Optional[]{mgr.func_215371_a(IRecipeType.field_222150_b, (IInventory)inv, world), mgr.func_215371_a(IRecipeType.field_222153_e, (IInventory)inv, world), mgr.func_215371_a(IRecipeType.field_222152_d, (IInventory)inv, world), Optional.empty()});
        return optRecipe.map(arg_0 -> Utils.lambda$findSmeltingResult$0((IInventory)inv, arg_0));
    }

    public static Predicate<? super Entity> selectEntities(Class<? extends Entity> ... entities) {
        return entity -> {
            if (entity == null || !entity.func_70089_S()) {
                return false;
            }
            Class<?> clazz = entity.getClass();
            for (Class test : entities) {
                if (!test.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        };
    }

    @Nullable
    public static <T> T selectClosest(Collection<T> elements, Function<T, Double> dstFunc) {
        if (elements.isEmpty()) {
            return null;
        }
        double dstClosest = Double.MAX_VALUE;
        T closestElement = null;
        for (T element : elements) {
            double dst = dstFunc.apply(element);
            if (!(dst < dstClosest)) continue;
            closestElement = element;
            dstClosest = dst;
        }
        return closestElement;
    }

    public static void writeCompoundNBTToBuffer(PacketBuffer bb, CompoundNBT nbt) {
        if (nbt == null) {
            bb.writeByte(0);
        } else {
            try {
                CompressedStreamTools.func_74800_a((CompoundNBT)nbt, (DataOutput)new ByteBufOutputStream((ByteBuf)bb));
            }
            catch (IOException ioexception) {
                throw new EncoderException((Throwable)ioexception);
            }
        }
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack s2 = stack.func_77946_l();
        s2.func_190920_e(amount);
        return s2;
    }

    public static CompoundNBT readCompoundNBTFromBuffer(PacketBuffer bb) {
        int i = bb.readerIndex();
        byte b0 = bb.readByte();
        if (b0 == 0) {
            return null;
        }
        bb.readerIndex(i);
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream((ByteBuf)bb), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static /* synthetic */ ItemStack lambda$findSmeltingResult$0(IInventory inv, IRecipe recipe) {
        return recipe.func_77572_b(inv).func_77946_l();
    }
}

