/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.gamestages;

import binary404.mystictools.common.loot.LootRarity;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.player.PlayerEntity;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.MysticTools.GameStages")
@ZenRegister
public class GameStageHandler {
    public static final Map<LootRarity, String> RARITY_MAP = new HashMap<LootRarity, String>();
    public static String openStage;

    public static boolean isRarityAllowed(PlayerEntity playerEntity, LootRarity rarity) {
        if (GameStageHelper.isStageKnown((String)RARITY_MAP.get(rarity))) {
            return GameStageHelper.hasStage((PlayerEntity)playerEntity, (String)RARITY_MAP.get(rarity));
        }
        return true;
    }

    @ZenCodeType.Method
    public static void addRarityStage(final String stage, final String rarity) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                LootRarity addRarity = LootRarity.fromId(rarity);
                RARITY_MAP.put(addRarity, stage);
            }

            public String describe() {
                return "Adding rarity " + rarity + " to stage " + stage;
            }
        });
    }

    @ZenCodeType.Method
    public static void addOpenStage(final String stage) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                openStage = stage;
            }

            public String describe() {
                return "Added open stage " + stage;
            }
        });
    }
}

