/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.items;

import binary404.mystictools.MysticTools;
import binary404.mystictools.common.items.ILootItem;
import binary404.mystictools.common.items.ModItems;
import binary404.mystictools.common.loot.LootItemHelper;
import binary404.mystictools.common.loot.LootNbtHelper;
import binary404.mystictools.common.loot.effects.LootEffect;
import binary404.mystictools.common.network.NetworkHandler;
import binary404.mystictools.common.network.PacketJump;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ItemLootArmor
extends ArmorItem
implements ILootItem {
    String type;
    private static int timesJumped;
    private static boolean jumpDown;

    public ItemLootArmor(EquipmentSlotType type, String pieceType) {
        super((IArmorMaterial)ArmorMaterial.DIAMOND, type, new Item.Properties().func_200916_a(MysticTools.tab));
        this.type = pieceType;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        Multimap<Attribute, AttributeModifier> modifiers = LootItemHelper.modifiersForStack(this.field_77881_a, this.field_77881_a, stack, (Multimap<Attribute, AttributeModifier>)HashMultimap.create(), "Armor modifier");
        return modifiers;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new StringTextComponent(LootItemHelper.getLootName(stack, super.func_200295_i(stack).getString()));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            LootItemHelper.addInformation(stack, tooltip, false);
        } else {
            EquipmentSlotType type = this.field_77881_a;
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RESET + "" + this.type));
            Multimap multimap = stack.func_111283_C(type);
            if (!multimap.isEmpty() && type != EquipmentSlotType.MAINHAND) {
                for (Map.Entry entry : multimap.entries()) {
                    if (!((Attribute)entry.getKey()).equals(Attributes.field_233827_j_) && !((Attribute)entry.getKey()).equals(Attributes.field_233826_i_)) continue;
                    AttributeModifier modifier = (AttributeModifier)entry.getValue();
                    double d0 = modifier.func_111164_d();
                    double d1 = modifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? d0 : d0 * 100.0;
                    if (d0 > 0.0) {
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + " " + I18n.func_135052_a((String)("attribute.modifier.plus." + modifier.func_220375_c().func_220371_a()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_135052_a((String)((Attribute)entry.getKey()).func_233754_c_(), (Object[])new Object[0])})));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RED + " " + I18n.func_135052_a((String)("attribute.modifier.take." + modifier.func_220375_c().func_220371_a()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), I18n.func_135052_a((String)((Attribute)entry.getKey()).func_233754_c_(), (Object[])new Object[0])})));
                }
            }
        }
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        LootItemHelper.handlePotionEffects(stack, null, (LivingEntity)player);
        List<LootEffect> effects = LootEffect.getEffectList(stack);
        if (effects.contains(LootEffect.getById("jump"))) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                if (player == Minecraft.func_71410_x().field_71439_g) {
                    ClientPlayerEntity playerSp = (ClientPlayerEntity)player;
                    if (playerSp.func_233570_aj_()) {
                        timesJumped = 0;
                    } else if (playerSp.field_71158_b.field_78901_c) {
                        if (!jumpDown && timesJumped < LootEffect.getAmplifierFromStack(stack, "jump")) {
                            playerSp.func_70664_aZ();
                            NetworkHandler.sendToServer(new PacketJump());
                            ++timesJumped;
                        }
                        jumpDown = true;
                    } else {
                        jumpDown = false;
                    }
                }
            });
        }
        for (LootEffect effect : effects) {
            if (effect.getAction() == null) continue;
            effect.getAction().handleUpdate(stack, world, (Entity)player, 0, false);
        }
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        int id = LootNbtHelper.getLootIntValue(stack, "model");
        String texture = "mystictools:textures/models/armor/1.png";
        if (id > 0) {
            texture = "mystictools:textures/models/armor/" + id;
        }
        if (stack.func_77973_b() == ModItems.loot_leggings) {
            texture = texture + "_2";
        }
        texture = texture + ".png";
        return texture;
    }

    public int getMaxDamage(ItemStack stack) {
        return LootItemHelper.getMaxDamage(stack);
    }
}

