/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.items;

import binary404.mystictools.MysticTools;
import binary404.mystictools.common.items.ILootItem;
import binary404.mystictools.common.items.MysticTier;
import binary404.mystictools.common.loot.LootItemHelper;
import binary404.mystictools.common.loot.LootNbtHelper;
import binary404.mystictools.common.loot.LootRarity;
import binary404.mystictools.common.loot.effects.LootEffect;
import binary404.mystictools.common.loot.effects.UniqueEffect;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ItemLootShovel
extends ShovelItem
implements ILootItem {
    public ItemLootShovel() {
        super((IItemTier)MysticTier.MYSTIC_TIER, 1.5f, -3.0f, new Item.Properties().func_200916_a(MysticTools.tab));
    }

    public boolean func_77636_d(ItemStack stack) {
        LootRarity rarity = LootRarity.fromId(LootNbtHelper.getLootStringValue(stack, "rarity"));
        return rarity == LootRarity.UNIQUE;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new StringTextComponent(LootItemHelper.getLootName(stack, super.func_200295_i(stack).getString()));
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        RayTraceResult raytrace;
        LootRarity rarity = LootRarity.fromId(LootNbtHelper.getLootStringValue(stack, "rarity"));
        if (rarity == LootRarity.UNIQUE) {
            UniqueEffect.getUniqueEffect(stack).breakBlock(pos, player.field_70170_p, player, stack);
        }
        boolean onBreak = super.onBlockStartBreak(stack, pos, player);
        LootItemHelper.handleBreak(stack, player, pos);
        if (LootItemHelper.hasEffect(stack, LootEffect.AREA_MINER) && LootNbtHelper.getLootIntValue(stack, "effect_level") > 1 && (raytrace = LootItemHelper.getBlockOnReach(player.field_70170_p, player)) != null) {
            int level = LootNbtHelper.getLootIntValue(stack, "effect_level");
            onBreak = LootItemHelper.breakBlocks(stack, level, player.field_70170_p, pos, ((BlockRayTraceResult)raytrace).func_216354_b(), player);
        }
        return onBreak;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        LootRarity rarity;
        if (entityIn instanceof LivingEntity && isSelected) {
            LootItemHelper.handlePotionEffects(stack, null, (LivingEntity)entityIn);
        }
        if ((rarity = LootRarity.fromId(LootNbtHelper.getLootStringValue(stack, "rarity"))) == LootRarity.UNIQUE) {
            UniqueEffect.getUniqueEffect(stack).tick(entityIn, stack);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        LootRarity rarity = LootRarity.fromId(LootNbtHelper.getLootStringValue(stack, "rarity"));
        if (rarity == LootRarity.UNIQUE) {
            UniqueEffect.getUniqueEffect(stack).rightClick((LivingEntity)playerIn, stack);
        }
        return LootItemHelper.use((ActionResult<ItemStack>)super.func_77659_a(worldIn, playerIn, handIn), worldIn, playerIn, handIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multiMap = HashMultimap.create();
        return LootItemHelper.modifiersForStack(slot, stack, (Multimap<Attribute, AttributeModifier>)multiMap, "Tool modifier");
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return LootItemHelper.getEfficiency(stack, state);
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        if (LootItemHelper.hasEffect(stack, LootEffect.MULTI)) {
            return Sets.newHashSet((Object[])new ToolType[]{ToolType.SHOVEL, ToolType.PICKAXE, ToolType.AXE});
        }
        return Sets.newHashSet((Object[])new ToolType[]{ToolType.SHOVEL});
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        if (LootItemHelper.hasEffect(stack, LootEffect.MULTI)) {
            return 3;
        }
        return super.getHarvestLevel(stack, tool, player, blockState);
    }

    public int getMaxDamage(ItemStack stack) {
        return LootItemHelper.getMaxDamage(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            LootItemHelper.addInformation(stack, tooltip);
        }
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RESET + "Shovel"));
        float efficiency = LootNbtHelper.getLootFloatValue(stack, "efficiency");
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "" + ItemStack.field_111284_a.format(efficiency) + " Mining Speed"));
    }
}

