/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.items;

import binary404.mystictools.MysticTools;
import binary404.mystictools.common.items.ILootItem;
import binary404.mystictools.common.items.MysticTier;
import binary404.mystictools.common.loot.LootItemHelper;
import binary404.mystictools.common.loot.LootNbtHelper;
import binary404.mystictools.common.loot.LootRarity;
import binary404.mystictools.common.loot.effects.UniqueEffect;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemLootSword
extends SwordItem
implements ILootItem {
    public ItemLootSword() {
        super((IItemTier)MysticTier.MYSTIC_TIER, 3, -2.4f, new Item.Properties().func_200916_a(MysticTools.tab));
    }

    public boolean func_77636_d(ItemStack stack) {
        LootRarity rarity = LootRarity.fromId(LootNbtHelper.getLootStringValue(stack, "rarity"));
        return rarity == LootRarity.UNIQUE;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new StringTextComponent(LootItemHelper.getLootName(stack, super.func_200295_i(stack).getString()));
    }

    public int getMaxDamage(ItemStack stack) {
        return LootItemHelper.getMaxDamage(stack);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean hit = super.func_77644_a(stack, target, attacker);
        LootItemHelper.handlePotionEffects(stack, target, attacker);
        LootItemHelper.handleHit(stack, target, attacker);
        LootRarity rarity = LootRarity.fromId(LootNbtHelper.getLootStringValue(stack, "rarity"));
        if (rarity == LootRarity.UNIQUE) {
            UniqueEffect.getUniqueEffect(stack).hit(target, attacker, stack);
        }
        return hit;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        LootRarity rarity = LootRarity.fromId(LootNbtHelper.getLootStringValue(stack, "rarity"));
        if (rarity == LootRarity.UNIQUE) {
            UniqueEffect.getUniqueEffect(stack).tick(entityIn, stack);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        LootRarity rarity = LootRarity.fromId(LootNbtHelper.getLootStringValue(stack, "rarity"));
        if (rarity == LootRarity.UNIQUE) {
            UniqueEffect.getUniqueEffect(stack).rightClick((LivingEntity)playerIn, stack);
        }
        return LootItemHelper.use((ActionResult<ItemStack>)super.func_77659_a(worldIn, playerIn, handIn), worldIn, playerIn, handIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multiMap = HashMultimap.create();
        return LootItemHelper.modifiersForStack(slot, stack, (Multimap<Attribute, AttributeModifier>)multiMap, "Weapon modifier");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int attackDamage = LootNbtHelper.getLootIntValue(stack, "damage");
        if (Screen.func_231173_s_()) {
            LootItemHelper.addInformation(stack, tooltip);
        }
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RESET + "Sword"));
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "" + attackDamage + " Damage"));
    }
}

