/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.loot;

import binary404.mystictools.common.core.ConfigHandler;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class LootRarity {
    private static final Map<String, LootRarity> REGISTRY = new HashMap<String, LootRarity>();
    public static LootRarity COMMON;
    public static LootRarity UNCOMMON;
    public static LootRarity RARE;
    public static LootRarity EPIC;
    public static LootRarity UNIQUE;
    private TextFormatting color = TextFormatting.WHITE;
    private int damageMin = 0;
    private int damageMax = 7;
    private float speedMin = 0.0f;
    private float speedMax = 1.0f;
    private float armorMin = 3.0f;
    private float armorMax = 10.0f;
    private float toughnessMin = 3.0f;
    private float tougnessMax = 10.0f;
    private float efficiencyMin = 1.0f;
    private float efficiencyMax = 1.0f;
    private int durabilityMin = 0;
    private int durabilityMax = 0;
    private int potionMin = 0;
    private int potionMax = 1;
    private int effectMin = 0;
    private int effectMax = 1;
    private String id;

    public static Map<String, LootRarity> getRegistry() {
        return REGISTRY;
    }

    public static LootRarity generateRandomRarity(Random random, PlayerEntity entity) {
        int rarity = random.nextInt(100) + 1;
        int commonRarity = (Integer)ConfigHandler.COMMON.commonRarity.get();
        int uncommonRarity = (Integer)ConfigHandler.COMMON.uncommonRarity.get();
        int rareRarity = (Integer)ConfigHandler.COMMON.rareRarity.get();
        int epicRarity = (Integer)ConfigHandler.COMMON.epicRarity.get();
        int uniqueRarity = (Integer)ConfigHandler.COMMON.uniqueRarity.get();
        LootRarity lootRarity = rarity <= commonRarity ? COMMON : (rarity > commonRarity && rarity <= commonRarity + uncommonRarity ? UNCOMMON : (rarity > commonRarity + uncommonRarity && rarity <= commonRarity + uncommonRarity + rareRarity ? RARE : (rarity > commonRarity + uncommonRarity + rareRarity && rarity <= commonRarity + uncommonRarity + rareRarity + epicRarity ? EPIC : (rarity > commonRarity + uncommonRarity + rareRarity + epicRarity && rarity <= commonRarity + uncommonRarity + rareRarity + epicRarity + uniqueRarity ? UNIQUE : COMMON))));
        return lootRarity;
    }

    public static void init() {
        COMMON = LootRarity.get("common", TextFormatting.WHITE).setDamage((Integer)ConfigHandler.COMMON.commonDamageMin.get(), (Integer)ConfigHandler.COMMON.commonDamageMax.get()).setSpeed(-3.1f, -2.399f).setArmor(1.0f, 3.0f).setToughness(0.0f, 0.0f).setEfficiency(5.0f, 12.0f).setDurability(100, 500).setPotionCount((Integer)ConfigHandler.COMMON.commonPotionMin.get(), (Integer)ConfigHandler.COMMON.commonPotionMax.get()).setEffectCount((Integer)ConfigHandler.COMMON.commonEffectMin.get(), (Integer)ConfigHandler.COMMON.commonEffectMax.get());
        UNCOMMON = LootRarity.get("uncommon", TextFormatting.GRAY).setDamage((Integer)ConfigHandler.COMMON.uncommonDamageMin.get(), (Integer)ConfigHandler.COMMON.uncommonDamageMax.get()).setSpeed(-2.8f, -2.3f).setArmor(2.0f, 5.0f).setToughness(1.0f, 3.0f).setEfficiency(11.0f, 25.0f).setDurability(350, 1450).setPotionCount((Integer)ConfigHandler.COMMON.uncommonPotionMin.get(), (Integer)ConfigHandler.COMMON.uncommonPotionMax.get()).setEffectCount((Integer)ConfigHandler.COMMON.uncommonEffectMin.get(), (Integer)ConfigHandler.COMMON.uncommonEffectMax.get());
        RARE = LootRarity.get("rare", TextFormatting.YELLOW).setDamage((Integer)ConfigHandler.COMMON.rareDamageMin.get(), (Integer)ConfigHandler.COMMON.rareDamageMax.get()).setSpeed(-2.6999f, -2.1f).setArmor(3.0f, 6.0f).setToughness(2.0f, 5.0f).setEfficiency(15.0f, 40.0f).setDurability(850, 2500).setPotionCount((Integer)ConfigHandler.COMMON.rarePotionMin.get(), (Integer)ConfigHandler.COMMON.rarePotionMax.get()).setEffectCount((Integer)ConfigHandler.COMMON.rareEffectMin.get(), (Integer)ConfigHandler.COMMON.rareEffectMax.get());
        EPIC = LootRarity.get("epic", TextFormatting.BLUE).setDamage((Integer)ConfigHandler.COMMON.epicDamageMin.get(), (Integer)ConfigHandler.COMMON.epicDamageMax.get()).setSpeed(-2.39999f, -1.8f).setArmor(4.0f, 8.0f).setToughness(1.0f, 5.0f).setEfficiency(20.0f, 42.0f).setDurability(2000, 4500).setPotionCount((Integer)ConfigHandler.COMMON.epicPotionMin.get(), (Integer)ConfigHandler.COMMON.epicPotionMax.get()).setEffectCount((Integer)ConfigHandler.COMMON.epicEffectMin.get(), (Integer)ConfigHandler.COMMON.epicEffectMax.get());
        UNIQUE = LootRarity.get("unique", TextFormatting.DARK_PURPLE).setDamage((Integer)ConfigHandler.COMMON.uniqueDamageMin.get(), (Integer)ConfigHandler.COMMON.uniqueDamageMax.get()).setSpeed(-2.0f, -1.5f).setArmor(5.0f, 10.0f).setToughness(2.0f, 6.0f).setEfficiency(20.56f, 56.05f).setDurability(1000, 4000).setPotionCount((Integer)ConfigHandler.COMMON.uniquePotionMin.get(), (Integer)ConfigHandler.COMMON.uniquePotionMax.get()).setEffectCount((Integer)ConfigHandler.COMMON.uniqueEffectMin.get(), (Integer)ConfigHandler.COMMON.uniqueEffectMax.get());
    }

    private LootRarity() {
    }

    public TextFormatting getColor() {
        return this.color;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public static LootRarity fromId(String id) {
        LootRarity r = null;
        if (REGISTRY.containsKey(id)) {
            r = REGISTRY.get(id);
        }
        return r;
    }

    public static LootRarity read(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && LootRarity.isValidPathCharacter(reader.peek())) {
            reader.skip();
        }
        String s = reader.getString().substring(i, reader.getCursor());
        try {
            return LootRarity.fromId(s);
        }
        catch (Exception e) {
            reader.setCursor(i);
            throw new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.id.invalid")).createWithContext((ImmutableStringReader)reader);
        }
    }

    public static boolean isValidPathCharacter(char charIn) {
        return charIn >= 'a' && charIn <= 'z';
    }

    protected LootRarity setPotionCount(int min, int max) {
        this.potionMin = min;
        this.potionMax = max;
        return this;
    }

    protected LootRarity setEffectCount(int min, int max) {
        this.effectMin = min;
        this.effectMax = max;
        return this;
    }

    protected LootRarity setDurability(int min, int max) {
        this.durabilityMin = min;
        this.durabilityMax = max;
        return this;
    }

    protected LootRarity setDamage(int min, int max) {
        this.damageMin = min;
        this.damageMax = max;
        return this;
    }

    protected LootRarity setSpeed(float min, float max) {
        this.speedMin = min;
        this.speedMax = max;
        return this;
    }

    protected LootRarity setArmor(float min, float max) {
        this.armorMin = min;
        this.armorMax = max;
        return this;
    }

    protected LootRarity setToughness(float min, float max) {
        this.toughnessMin = min;
        this.tougnessMax = max;
        return this;
    }

    protected LootRarity setEfficiency(float min, float max) {
        this.efficiencyMin = min;
        this.efficiencyMax = max;
        return this;
    }

    public int getPotionCount(Random rand) {
        int modifierCount = this.potionMin;
        if (modifierCount < this.potionMax) {
            modifierCount += rand.nextInt(this.potionMax - modifierCount + 1);
        }
        return modifierCount;
    }

    public int getEffectCount(Random rand) {
        int modifierCount = this.effectMin;
        if (modifierCount < this.effectMax) {
            modifierCount += rand.nextInt(this.effectMax - modifierCount + 1);
        }
        return modifierCount;
    }

    public int getDurability(Random rand) {
        int durability = this.durabilityMin;
        if (durability < this.durabilityMax) {
            durability += rand.nextInt(this.durabilityMax - durability + 1);
        }
        return durability;
    }

    public int getDamage(Random rand) {
        int damage = this.damageMin;
        if (damage < this.damageMax) {
            damage += rand.nextInt(this.damageMax - damage + 1);
        }
        return damage;
    }

    public float getSpeed(Random rand) {
        float speed = this.speedMin;
        speed += (this.speedMax - speed) * rand.nextFloat();
        return speed;
    }

    public float getArmor(Random rand) {
        float armor = this.armorMin;
        armor += (this.armorMax - armor) * rand.nextFloat();
        armor = (float)Math.round(armor * 100.0f) / 100.0f;
        return armor;
    }

    public float getToughness(Random rand) {
        float toughness = this.toughnessMin;
        toughness += (this.tougnessMax - toughness) * rand.nextFloat();
        toughness = (float)Math.round(toughness * 100.0f) / 100.0f;
        return toughness;
    }

    public float getEfficiency(Random rand) {
        float efficiency = this.efficiencyMin;
        efficiency += (this.efficiencyMax - efficiency) * rand.nextFloat();
        return efficiency;
    }

    protected static LootRarity get(String id, TextFormatting color) {
        LootRarity r = new LootRarity();
        r.id = id;
        r.color = color;
        REGISTRY.put(id, r);
        return r;
    }
}

