/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.loot.effects;

import binary404.mystictools.common.core.ConfigHandler;
import binary404.mystictools.common.loot.LootNbtHelper;
import binary404.mystictools.common.loot.LootSet;
import binary404.mystictools.common.loot.effects.IEffect;
import binary404.mystictools.common.loot.effects.IEffectAction;
import binary404.mystictools.common.loot.effects.effect.LootEffectActionSleep;
import binary404.mystictools.common.loot.effects.effect.LootEffectAreaMiner;
import binary404.mystictools.common.loot.effects.effect.LootEffectAutoSmelt;
import binary404.mystictools.common.loot.effects.effect.LootEffectDash;
import binary404.mystictools.common.loot.effects.effect.LootEffectHeal;
import binary404.mystictools.common.loot.effects.effect.LootEffectLightning;
import binary404.mystictools.common.loot.effects.effect.LootEffectShockwave;
import binary404.mystictools.common.loot.effects.effect.LootEffectStun;
import binary404.mystictools.common.loot.effects.effect.LootEffectVoid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class LootEffect
implements IEffect {
    public static final Map<String, LootEffect> REGISTRY = new HashMap<String, LootEffect>();
    public static LootEffect LIGHTNING;
    public static LootEffect LEECH;
    public static LootEffect HEAL;
    public static LootEffect DASH;
    public static LootEffect STUN;
    public static LootEffect SLEEP;
    public static LootEffect MULTI;
    public static LootEffect AREA_MINER;
    public static LootEffect AUTO_SMELT;
    public static LootEffect VOID;
    public static LootEffect JUMP;
    public static LootEffect PARRY;
    public static LootEffect SHOCKWAVE;
    public static LootEffect REFLECT;
    public static LootEffect HEALTH;
    public static LootEffect KNOCKBACK_RESISTANCE;
    public static LootEffect INSIGHT;
    private String id;
    private List<LootSet.LootSetType> applyToItems = new ArrayList<LootSet.LootSetType>();
    private Attribute attribute;
    private IEffectAction action;
    private int amplifierMin = 0;
    private int amplifierMax = 0;
    private final EffectType effectType;

    public static void init() {
        if (((Boolean)ConfigHandler.COMMON.enableLightning.get()).booleanValue()) {
            LIGHTNING = LootEffect.create("lightning", EffectType.PASSIVE).setAction(new LootEffectLightning()).setItemTypes(LootSet.LootSetType.SWORD);
        }
        if (((Boolean)ConfigHandler.COMMON.enableLeach.get()).booleanValue()) {
            LEECH = LootEffect.create("leech", EffectType.PASSIVE).setAmplifier(1, (Integer)ConfigHandler.COMMON.maxLeachAmount.get()).setItemTypes(LootSet.LootSetType.SWORD);
        }
        if (((Boolean)ConfigHandler.COMMON.enableHeal.get()).booleanValue()) {
            HEAL = LootEffect.create("heal", EffectType.USE).setAction(new LootEffectHeal()).setItemTypes(LootSet.LootSetType.SWORD);
        }
        if (((Boolean)ConfigHandler.COMMON.enableDash.get()).booleanValue()) {
            DASH = LootEffect.create("dash", EffectType.USE).setAction(new LootEffectDash()).setItemTypes(LootSet.LootSetType.SWORD);
        }
        if (((Boolean)ConfigHandler.COMMON.enableStun.get()).booleanValue()) {
            STUN = LootEffect.create("stun", EffectType.USE).setAction(new LootEffectStun()).setItemTypes(LootSet.LootSetType.SWORD);
        }
        if (((Boolean)ConfigHandler.COMMON.enableSleep.get()).booleanValue()) {
            SLEEP = LootEffect.create("sleep", EffectType.USE).setAction(new LootEffectActionSleep()).setItemTypes(LootSet.LootSetType.PICKAXE, LootSet.LootSetType.AXE, LootSet.LootSetType.SHOVEL);
        }
        if (((Boolean)ConfigHandler.COMMON.enableMultiTool.get()).booleanValue()) {
            MULTI = LootEffect.create("multi", EffectType.PASSIVE).setItemTypes(LootSet.LootSetType.AXE, LootSet.LootSetType.SHOVEL, LootSet.LootSetType.PICKAXE);
        }
        if (((Boolean)ConfigHandler.COMMON.enableAreaMiner.get()).booleanValue()) {
            AREA_MINER = LootEffect.create("area_miner", EffectType.ACTIVE).setItemTypes(LootSet.LootSetType.PICKAXE, LootSet.LootSetType.SHOVEL, LootSet.LootSetType.AXE).setAction(new LootEffectAreaMiner());
        }
        if (((Boolean)ConfigHandler.COMMON.enableAutoSmelt.get()).booleanValue()) {
            AUTO_SMELT = LootEffect.create("auto_smelt", EffectType.ACTIVE).setItemTypes(LootSet.LootSetType.PICKAXE, LootSet.LootSetType.SHOVEL, LootSet.LootSetType.AXE).setAction(new LootEffectAutoSmelt());
        }
        if (((Boolean)ConfigHandler.COMMON.enableVoid.get()).booleanValue()) {
            VOID = LootEffect.create("void", EffectType.ACTIVE).setItemTypes(LootSet.LootSetType.PICKAXE, LootSet.LootSetType.AXE, LootSet.LootSetType.SHOVEL).setAction(new LootEffectVoid());
        }
        if (((Boolean)ConfigHandler.COMMON.enableJump.get()).booleanValue()) {
            JUMP = LootEffect.create("jump", EffectType.PASSIVE).setAmplifier(2, (Integer)ConfigHandler.COMMON.maxJumpAmount.get()).setItemTypes(LootSet.LootSetType.ARMOR_BOOTS);
        }
        if (((Boolean)ConfigHandler.COMMON.enableParry.get()).booleanValue()) {
            PARRY = LootEffect.create("parry", EffectType.PASSIVE).setAmplifier(10, (Integer)ConfigHandler.COMMON.maxParryChance.get()).setItemTypes(LootSet.LootSetType.ARMOR_BOOTS);
        }
        if (((Boolean)ConfigHandler.COMMON.enableShockwave.get()).booleanValue()) {
            SHOCKWAVE = LootEffect.create("shockwave", EffectType.PASSIVE).setAction(new LootEffectShockwave()).setItemTypes(LootSet.LootSetType.ARMOR_LEGGINGS, LootSet.LootSetType.ARMOR_CHESTPLATE);
        }
        if (((Boolean)ConfigHandler.COMMON.enableReflect.get()).booleanValue()) {
            REFLECT = LootEffect.create("reflect", EffectType.PASSIVE).setItemTypes(LootSet.LootSetType.ARMOR_CHESTPLATE, LootSet.LootSetType.ARMOR_LEGGINGS);
        }
        if (((Boolean)ConfigHandler.COMMON.enableHealth.get()).booleanValue()) {
            HEALTH = LootEffect.create("health", EffectType.PASSIVE, Attributes.field_233818_a_).setAmplifier(1, (Integer)ConfigHandler.COMMON.maxHealth.get()).setItemTypes(LootSet.LootSetType.ARMOR_LEGGINGS, LootSet.LootSetType.ARMOR_CHESTPLATE);
        }
        if (((Boolean)ConfigHandler.COMMON.enableKnockbackResistance.get()).booleanValue()) {
            KNOCKBACK_RESISTANCE = LootEffect.create("knockback_resistance", EffectType.PASSIVE, Attributes.field_233820_c_).setAmplifier(1, (Integer)ConfigHandler.COMMON.maxKnockbackResistance.get()).setItemTypes(LootSet.LootSetType.ARMOR_CHESTPLATE, LootSet.LootSetType.ARMOR_LEGGINGS);
        }
        if (((Boolean)ConfigHandler.COMMON.enableInsight.get()).booleanValue()) {
            INSIGHT = LootEffect.create("insight", EffectType.PASSIVE).setAmplifier(1, (Integer)ConfigHandler.COMMON.maxInsight.get()).setItemTypes(LootSet.LootSetType.ARMOR_HELMET);
        }
    }

    private LootEffect(EffectType type) {
        this.effectType = type;
    }

    public EffectType getType() {
        return this.effectType;
    }

    public boolean applyToItemType(LootSet.LootSetType type) {
        return this.applyToItems.contains((Object)type);
    }

    public IEffectAction getAction() {
        return this.action;
    }

    protected LootEffect setAction(IEffectAction action) {
        this.action = action;
        return this;
    }

    protected LootEffect setItemTypes(LootSet.LootSetType ... itemTypes) {
        for (LootSet.LootSetType itemType : itemTypes) {
            this.applyToItems.add(itemType);
        }
        return this;
    }

    public static LootEffect getById(String id) {
        LootEffect weaponEffect = REGISTRY.get(id);
        return weaponEffect;
    }

    public String getId() {
        return this.id;
    }

    public CompoundNBT getNbt(Random rand) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("id", this.getId());
        tag.func_74768_a("amplifier", this.getAmplifier(rand));
        return tag;
    }

    public static int getAmplifierFromStack(ItemStack stack, String effectId) {
        int amplifier = 0;
        ListNBT effectTagList = LootNbtHelper.getLootTagList(stack, "effectList");
        int count = effectTagList.size();
        for (int i = 0; i < count; ++i) {
            CompoundNBT e = effectTagList.func_150305_b(i);
            if (!e.func_74779_i("id").contains(effectId)) continue;
            amplifier = e.func_74762_e("amplifier");
        }
        return amplifier;
    }

    public static List<LootEffect> getEffectList(ItemStack stack) {
        ArrayList<LootEffect> list = new ArrayList<LootEffect>();
        ListNBT effectList = LootNbtHelper.getLootTagList(stack, "effectList");
        int count = effectList.size();
        for (int i = 0; i < count; ++i) {
            CompoundNBT e = effectList.func_150305_b(i);
            list.add(LootEffect.getById(e.func_74779_i("id")));
        }
        return list;
    }

    protected static LootEffect create(String id, EffectType type) {
        LootEffect effect = new LootEffect(type);
        effect.id = id;
        REGISTRY.put(id, effect);
        return effect;
    }

    protected static LootEffect create(String id, EffectType type, Attribute attribute) {
        LootEffect effect = new LootEffect(type);
        effect.id = id;
        effect.attribute = attribute;
        REGISTRY.put(id, effect);
        return effect;
    }

    protected LootEffect setAmplifier(int min, int max) {
        this.amplifierMin = min;
        this.amplifierMax = max;
        return this;
    }

    private int getAmplifier(Random rand) {
        return MathHelper.func_76136_a((Random)rand, (int)this.amplifierMin, (int)this.amplifierMax);
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public String getActionStatus(ItemStack stack) {
        String statusString = "";
        if (this.getAction() != null) {
            statusString = this.getAction().getStatusString(stack);
        }
        return statusString;
    }

    public String getAmplifierString(ItemStack stack, String effectId) {
        return this.getAmplifierString(stack, effectId, 0);
    }

    public String getAmplifierString(ItemStack stack, String effectId, int add) {
        return TextFormatting.BOLD + "" + (LootEffect.getAmplifierFromStack(stack, effectId) + add) + "" + TextFormatting.RESET + "" + (this.getType() == EffectType.PASSIVE ? TextFormatting.GREEN : TextFormatting.GOLD) + "";
    }

    public static enum EffectType {
        ACTIVE(TextFormatting.GOLD),
        PASSIVE(TextFormatting.GREEN),
        USE(TextFormatting.AQUA);

        private TextFormatting color;

        private EffectType(TextFormatting color) {
            this.color = color;
        }

        public TextFormatting getColor() {
            return this.color;
        }

        public boolean equals(EffectType type) {
            return type == this;
        }
    }
}

