/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.loot.effects.unique;

import binary404.mystictools.common.core.util.Utils;
import binary404.mystictools.common.loot.effects.IUniqueEffect;
import binary404.mystictools.common.network.NetworkHandler;
import binary404.mystictools.common.network.PacketArc;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class Arc
implements IUniqueEffect {
    @Override
    public void hit(LivingEntity target, LivingEntity attacker, ItemStack stack) {
        if (attacker instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)attacker;
            new ArcEffect(player.field_70170_p, player, target).start();
        }
    }

    protected LogicalSide getSide(Entity entity) {
        return entity.func_130014_f_().func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER;
    }

    static class ArcEffect {
        private final World world;
        private final PlayerEntity player;
        private final LivingEntity target;

        public ArcEffect(World world, PlayerEntity player, LivingEntity target) {
            this.world = world;
            this.player = player;
            this.target = target;
        }

        void start() {
            if (!this.player.func_70089_S()) {
                return;
            }
            int times = 10;
            ArrayList targetedEntities = Lists.newArrayList();
            LivingEntity start = this.target;
            AxisAlignedBB box = new AxisAlignedBB(-20.0, -20.0, -20.0, 20.0, 20.0, 20.0);
            LivingEntity last = null;
            LivingEntity entity = start;
            while (entity != null && times > 0) {
                targetedEntities.add(entity);
                --times;
                if (last != null) {
                    Vector3d from = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()).func_72441_c(0.5, 0.5, 0.5);
                    Vector3d to = new Vector3d(last.func_226277_ct_(), last.func_226278_cu_(), last.func_226281_cx_()).func_72441_c(0.5, 0.5, 0.5);
                    NetworkHandler.sendToNearby(this.world, (Entity)entity, (Object)new PacketArc(from.field_72450_a, from.field_72448_b, from.field_72449_c, to.field_72450_a, to.field_72448_b, to.field_72449_c));
                }
                List entities = entity.func_130014_f_().func_175647_a(LivingEntity.class, box.func_191194_a(entity.func_213303_ch()), Utils.selectEntities(LivingEntity.class));
                entities.remove(entity);
                if (last != null) {
                    entities.remove(last);
                }
                entities.remove(this.player);
                entities.removeAll(targetedEntities);
                if (!entities.isEmpty()) {
                    LivingEntity tmpEntity = entity;
                    LivingEntity closest = Utils.selectClosest(entities, e -> e.func_70032_d((Entity)tmpEntity));
                    if (closest != null && closest.func_70089_S()) {
                        last = entity;
                        entity = closest;
                        continue;
                    }
                    entity = null;
                    continue;
                }
                entity = null;
            }
            if (targetedEntities.size() > 1) {
                targetedEntities.forEach(e -> e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)this.player), 10.0f));
            }
        }
    }
}

