/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.loot.effects.unique;

import binary404.mystictools.common.loot.effects.IUniqueEffect;
import binary404.mystictools.common.network.NetworkHandler;
import binary404.mystictools.common.network.PacketSparkle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public class TreeChopper
implements IUniqueEffect {
    private static final int BLOCK_SWAP_RATE = 3;
    private static final int LEAF_BLOCK_RANGE = 5;
    private static final Map<DimensionType, Set<BlockSwapper>> blockSwappers = new HashMap<DimensionType, Set<BlockSwapper>>();
    public static final List<Material> materialsAxe = Arrays.asList(Material.field_151589_v, Material.field_151584_j, Material.field_151585_k, Material.field_151575_d, Material.field_151572_C);

    public TreeChopper() {
        MinecraftForge.EVENT_BUS.addListener(this::tickEnd);
    }

    private void tickEnd(TickEvent.WorldTickEvent event) {
        DimensionType dim;
        if (event.world.field_72995_K) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && event.world.func_82737_E() % 5L == 0L && blockSwappers.containsKey(dim = event.world.func_230315_m_())) {
            Set<BlockSwapper> swappers = blockSwappers.get(dim);
            swappers.removeIf(next -> next == null || !next.tick());
        }
    }

    @Override
    public void breakBlock(BlockPos pos, World world, PlayerEntity player, ItemStack stack) {
        TreeChopper.addBlockSwapper(world, player, stack, pos, 32, true);
    }

    private static void addBlockSwapper(World world, PlayerEntity player, ItemStack stack, BlockPos origCoords, int steps, boolean leaves) {
        BlockSwapper swapper = new BlockSwapper(world, player, stack, origCoords, steps, leaves);
        if (world.field_72995_K) {
            return;
        }
        DimensionType dim = world.func_230315_m_();
        blockSwappers.computeIfAbsent(dim, d -> new HashSet()).add(swapper);
    }

    public static void removeBlockWithDrops(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Predicate<BlockState> filter, boolean dispose, boolean particles) {
        if (!world.func_175667_e(pos)) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!world.field_72995_K && filter.test(state) && !block.isAir(state, (IBlockReader)world, pos) && state.func_185903_a(player, (IBlockReader)world, pos) > 0.0f && state.canHarvestBlock((IBlockReader)player.field_70170_p, pos, player)) {
            int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((ServerPlayerEntity)player).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)player), (BlockPos)pos);
            if (exp == -1) {
                return;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                TileEntity tile = world.func_175625_s(pos);
                if (block.removedByPlayer(state, world, pos, player, true, world.func_204610_c(pos))) {
                    block.func_176206_d((IWorld)world, pos, state);
                    if (!dispose) {
                        block.func_180657_a(world, player, pos, state, tile, stack);
                        if (world instanceof ServerWorld) {
                            block.func_180637_b((ServerWorld)world, pos, exp);
                        }
                    }
                }
            } else {
                world.func_217377_a(pos, false);
            }
            if (particles) {
                NetworkHandler.sendToNearby(world, (Entity)player, (Object)new PacketSparkle((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.1f, 0.96f, 0.1f));
                world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            }
        }
    }

    private static class BlockSwapper {
        public static final int SINGLE_BLOCK_RADIUS = 1;
        private final World world;
        private final PlayerEntity player;
        private final ItemStack stack;
        private final BlockPos origin;
        private final boolean treatLeavesSpecial;
        private final int range;
        private final PriorityQueue<SwapCandidate> candidateQueue;
        private final Set<BlockPos> completedCoords;

        public BlockSwapper(World world, PlayerEntity player, ItemStack truncator, BlockPos origCoords, int range, boolean leaves) {
            this.world = world;
            this.player = player;
            this.stack = truncator;
            this.origin = origCoords;
            this.range = range;
            this.treatLeavesSpecial = leaves;
            this.candidateQueue = new PriorityQueue();
            this.completedCoords = new HashSet<BlockPos>();
            this.candidateQueue.offer(new SwapCandidate(this.origin, this.range));
        }

        public boolean tick() {
            if (this.candidateQueue.isEmpty()) {
                return false;
            }
            int remainingSwaps = 3;
            while (remainingSwaps > 0 && !this.candidateQueue.isEmpty()) {
                SwapCandidate cand = this.candidateQueue.poll();
                if (this.completedCoords.contains(cand.coordinates) || cand.range <= 0) continue;
                TreeChopper.removeBlockWithDrops(this.player, this.stack, this.world, cand.coordinates, state -> materialsAxe.contains(state.func_185904_a()), false, this.treatLeavesSpecial);
                --remainingSwaps;
                this.completedCoords.add(cand.coordinates);
                for (BlockPos adj : this.adjacent(cand.coordinates)) {
                    Block block = this.world.func_180495_p(adj).func_177230_c();
                    boolean isWood = BlockTags.field_200031_h.func_230235_a_((Object)block);
                    boolean isLeaf = BlockTags.field_206952_E.func_230235_a_((Object)block);
                    if (!isWood && !isLeaf) continue;
                    int newRange = this.treatLeavesSpecial && isLeaf ? Math.min(5, cand.range - 1) : cand.range - 1;
                    this.candidateQueue.offer(new SwapCandidate(adj, newRange));
                }
            }
            return true;
        }

        public List<BlockPos> adjacent(BlockPos original) {
            ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        coords.add(original.func_177982_a(dx, dy, dz));
                    }
                }
            }
            return coords;
        }

        public static final class SwapCandidate
        implements Comparable<SwapCandidate> {
            public final BlockPos coordinates;
            public final int range;

            public SwapCandidate(BlockPos coordinates, int range) {
                this.coordinates = coordinates;
                this.range = range;
            }

            @Override
            public int compareTo(@Nonnull SwapCandidate other) {
                return other.range - this.range;
            }

            public boolean equals(Object other) {
                if (!(other instanceof SwapCandidate)) {
                    return false;
                }
                SwapCandidate cand = (SwapCandidate)other;
                return this.coordinates.equals((Object)cand.coordinates) && this.range == cand.range;
            }

            public int hashCode() {
                return Objects.hash(this.coordinates, this.range);
            }
        }
    }
}

