/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.tile;

import binary404.mystictools.common.items.ILootItem;
import binary404.mystictools.common.items.ModItems;
import binary404.mystictools.common.loot.ItemTypeRegistry;
import binary404.mystictools.common.loot.LootItemHelper;
import binary404.mystictools.common.loot.LootNbtHelper;
import binary404.mystictools.common.loot.LootSet;
import binary404.mystictools.common.loot.effects.LootEffect;
import binary404.mystictools.common.loot.effects.PotionEffect;
import binary404.mystictools.common.tile.ModTiles;
import binary404.mystictools.common.tile.UpgraderContainer;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileEntityUpgrader
extends TileEntity
implements INamedContainerProvider {
    protected ItemStackHandler output;
    private final LazyOptional<IItemHandler> outputHolder = LazyOptional.of(() -> this.output);
    protected ItemStackHandler storage;
    private final LazyOptional<IItemHandler> storageHolder = LazyOptional.of(() -> this.storage);

    public TileEntityUpgrader() {
        super(ModTiles.UPGRADER);
        this.storage = new StackHandler(this, 2, true);
        this.output = new StackHandler(this, 1, false);
    }

    public void upgrade() {
        ItemStack loot = this.storage.getStackInSlot(0);
        ItemStack modifier = this.storage.getStackInSlot(1);
        int upgrades = LootNbtHelper.getLootIntValue(loot, "upgrade");
        if (loot.func_77973_b() instanceof ILootItem && modifier.func_77973_b() == ModItems.charm && modifier.func_190916_E() >= 1 && upgrades >= 1) {
            List<LootEffect> effects = LootEffect.getEffectList(loot);
            List<PotionEffect> potionEffects = PotionEffect.getPotionlist(loot);
            LootSet.LootSetType type = ItemTypeRegistry.getItemType(loot.func_77973_b());
            if (this.field_145850_b.field_73012_v.nextBoolean()) {
                LootEffect effect = LootItemHelper.getRandomEffectExcluding(this.field_145850_b.field_73012_v, type, effects);
                if (effect != null) {
                    ListNBT effectList = LootNbtHelper.getLootTagList(loot, "effectList");
                    effectList.add((Object)effect.getNbt(this.field_145850_b.field_73012_v));
                    LootNbtHelper.setLootTagList(loot, "effectList", effectList);
                    modifier.func_190918_g(1);
                    LootNbtHelper.setLootIntValue(loot, "upgrade", --upgrades);
                }
            } else {
                PotionEffect effect = LootItemHelper.getRandomPotionExcluding(this.field_145850_b.field_73012_v, type, potionEffects);
                if (effect != null) {
                    ListNBT potionList = LootNbtHelper.getLootTagList(loot, "potionList");
                    potionList.add((Object)effect.getNbt(this.field_145850_b.field_73012_v));
                    LootNbtHelper.setLootTagList(loot, "potionList", potionList);
                    modifier.func_190918_g(1);
                    LootNbtHelper.setLootIntValue(loot, "upgrade", --upgrades);
                }
            }
            this.output.setStackInSlot(0, loot);
            this.storage.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    public void reroll() {
        ItemStack loot = this.storage.getStackInSlot(0);
        ItemStack dice = this.storage.getStackInSlot(1);
        if (loot.func_77973_b() instanceof ILootItem && dice.func_77973_b() == ModItems.dice && dice.func_190916_E() >= 1) {
            LootItemHelper.rerollStats(loot);
            this.output.setStackInSlot(0, loot);
            this.storage.setStackInSlot(0, ItemStack.field_190927_a);
            dice.func_190918_g(1);
            this.func_70296_d();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            this.func_70296_d();
            if (side == Direction.UP) {
                return this.storageHolder.cast();
            }
            if (side == Direction.EAST) {
                return this.storageHolder.cast();
            }
            if (side == Direction.NORTH) {
                return this.storageHolder.cast();
            }
            if (side == Direction.WEST) {
                return this.storageHolder.cast();
            }
            if (side == Direction.SOUTH) {
                return this.storageHolder.cast();
            }
            if (side == Direction.DOWN) {
                return this.outputHolder.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.mystictools.upgrader");
    }

    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        return new UpgraderContainer(p_createMenu_1_, p_createMenu_2_, (IItemHandler)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.storage, this.output}), this);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT c = super.func_189515_b(compound);
        c.func_218657_a("storage", (INBT)this.storage.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbtIn) {
        super.func_230337_a_(state, nbtIn);
        this.storage.deserializeNBT(nbtIn.func_74775_l("storage"));
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 42, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public static class StackHandler
    extends ItemStackHandler {
        TileEntity tileEntity;
        public boolean allowInput;

        public StackHandler(TileEntity tile, int size, boolean allowInput) {
            super(size);
            this.tileEntity = tile;
            this.allowInput = allowInput;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.allowInput) {
                this.tileEntity.func_70296_d();
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            this.tileEntity.func_70296_d();
            return super.extractItem(slot, amount, simulate);
        }
    }
}

