/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.common.world;

import binary404.mystictools.common.loot.effects.UniqueEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.registries.ForgeRegistries;

public class UniqueSave
extends WorldSavedData {
    public List<UniqueInfo> uniques = new ArrayList<UniqueInfo>();

    public UniqueSave() {
        super("mystictools_unique");
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.uniques.clear();
        ArrayList<UniqueInfo> info = new ArrayList<UniqueInfo>();
        ListNBT list = nbt.func_150295_c("list", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT cmp = list.func_150305_b(i);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(cmp.func_74779_i("item")));
            UniqueEffect effect = UniqueEffect.getById(cmp.func_74779_i("effect"));
            boolean found = cmp.func_74767_n("found");
            info.add(new UniqueInfo(item, effect, found));
        }
        this.uniques = info;
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (UniqueInfo info : this.uniques) {
            CompoundNBT cmp = new CompoundNBT();
            cmp.func_74778_a("item", info.item.getRegistryName().toString());
            cmp.func_74778_a("effect", info.effect.getId());
            cmp.func_74757_a("found", info.found);
            list.add((Object)cmp);
        }
        nbt.func_218657_a("list", (INBT)list);
        return nbt;
    }

    public static UniqueSave forWorld(ServerWorld world) {
        Supplier<UniqueSave> sup;
        DimensionSavedDataManager storage = world.func_217481_x();
        UniqueSave saver = (UniqueSave)storage.func_215752_a(sup = () -> new UniqueSave(), "mystictools_unique");
        if (saver == null) {
            saver = new UniqueSave();
            storage.func_215757_a((WorldSavedData)saver);
        }
        return saver;
    }

    public static class UniqueInfo {
        public Item item;
        public UniqueEffect effect;
        public boolean found;

        public UniqueInfo(Item item, UniqueEffect effect, boolean found) {
            this.item = item;
            this.effect = effect;
            this.found = found;
        }

        public String toString() {
            return this.item.getRegistryName() + " " + this.effect.getId() + " " + this.found;
        }
    }
}

