/*
 * Decompiled with CFR 0.152.
 */
package binary404.mystictools.proxy;

import binary404.mystictools.client.RenderCauldron;
import binary404.mystictools.client.fx.FXBlock;
import binary404.mystictools.client.fx.FXHelper;
import binary404.mystictools.client.fx.ModEffects;
import binary404.mystictools.client.gui.GuiUpgrader;
import binary404.mystictools.common.core.ClientHandler;
import binary404.mystictools.common.items.ILootItem;
import binary404.mystictools.common.items.ItemLootBow;
import binary404.mystictools.common.items.ModItems;
import binary404.mystictools.common.tile.ModContainers;
import binary404.mystictools.common.tile.ModTiles;
import binary404.mystictools.proxy.IProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.particle.Particle;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientProxy
implements IProxy {
    @Override
    public void registerHandlers() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            ClientHandler.KeyBindings.init();
            ClientProxy.registerPropertyGetters();
        });
        ClientRegistry.bindTileEntityRenderer(ModTiles.CAULDRON, RenderCauldron::new);
        ScreenManager.func_216911_a(ModContainers.UPGRADER, GuiUpgrader::new);
        if (FXHelper.fxlibLoaded()) {
            ModEffects.init();
        }
    }

    private static void registerPropertyGetter(IItemProvider item, ResourceLocation id, IItemPropertyGetter propGetter) {
        ItemModelsProperties.func_239418_a_((Item)item.func_199767_j(), (ResourceLocation)id, (IItemPropertyGetter)propGetter);
    }

    private static void registerPropertyGetters() {
        IItemPropertyGetter lootGetter = (stack, world, entity) -> {
            ILootItem item = (ILootItem)stack.func_77973_b();
            return item.getModel(stack);
        };
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.loot_sword, new ResourceLocation("model"), lootGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.loot_bow, new ResourceLocation("model"), lootGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.loot_shovel, new ResourceLocation("model"), lootGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.loot_pickaxe, new ResourceLocation("model"), lootGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.loot_axe, new ResourceLocation("model"), lootGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.loot_boots, new ResourceLocation("model"), lootGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.loot_leggings, new ResourceLocation("model"), lootGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.loot_chestplate, new ResourceLocation("model"), lootGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.loot_helmet, new ResourceLocation("model"), lootGetter);
        IItemPropertyGetter pulling = (stack, world, entity) -> {
            ItemLootBow bow = (ItemLootBow)stack.func_77973_b();
            return bow.getPulling(stack, (World)world, entity);
        };
        IItemPropertyGetter pull = (stack, world, entity) -> {
            ItemLootBow bow = (ItemLootBow)stack.func_77973_b();
            return bow.getPull(stack, (World)world, entity);
        };
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.loot_bow, new ResourceLocation("ml_pull"), pull);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.loot_bow, new ResourceLocation("ml_pulling"), pulling);
    }

    @Override
    public World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void blockFX(BlockPos pos) {
        FXBlock data = new FXBlock(Minecraft.func_71410_x().field_71441_e, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, true, 600, this.getWorld().func_180495_p(pos).func_177230_c());
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)data);
    }

    @Override
    public void scheduleDelayed(Runnable r, int delay) {
        System.out.println("Scheduling runnable on client");
    }
}

