/*
 * Decompiled with CFR 0.152.
 */
package binary404.MysticTools.block;

import binary404.MysticTools.item.MysticToolsItems;
import binary404.MysticTools.loot.LootItemHelper;
import binary404.MysticTools.loot.LootRarity;
import binary404.MysticTools.loot.LootSet;
import binary404.MysticTools.loot.LootWeaponEffect;
import binary404.MysticTools.loot.item.ItemWeaponCase;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class BehaviourLootCase
extends BehaviorDefaultDispenseItem {
    Random itemRand = new Random();

    @Nonnull
    protected ItemStack func_82487_b(IBlockSource source, ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemWeaponCase) {
            LootRarity case_rarity = ((ItemWeaponCase)itemStack.func_77973_b()).getCase_rarity();
            for (int i = 0; i < 1; ++i) {
                ItemStack loot = LootItemHelper.getRandomLoot(this.itemRand, case_rarity);
                LootSet.LootSetType type = MysticToolsItems.getItemType(loot.func_77973_b());
                if (type == null) {
                    type = LootSet.LootSetType.SWORD;
                }
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("HideFlags", 2);
                NBTTagCompound mlTag = new NBTTagCompound();
                int model = 1 + this.itemRand.nextInt(type.models);
                mlTag.func_74768_a("model", model);
                mlTag.func_74778_a("uuid", UUID.randomUUID().toString());
                mlTag.func_74778_a("rarity", case_rarity.getId());
                mlTag.func_74768_a("damage", case_rarity.getDamage(this.itemRand));
                mlTag.func_74776_a("speed", case_rarity.getSpeed(this.itemRand));
                mlTag.func_74776_a("efficiency", case_rarity.getEfficiency(this.itemRand));
                mlTag.func_74768_a("durability", case_rarity.getDurability(this.itemRand));
                mlTag.func_74768_a("upgrades", case_rarity.getUpgrades(this.itemRand));
                mlTag.func_74776_a("drawspeed", case_rarity.getSpeed(this.itemRand) + 4.0f);
                mlTag.func_74776_a("power", 1.0f + (float)case_rarity.getDamage(this.itemRand) / 20.0f);
                if (type == LootSet.LootSetType.ARMOR_HEAD || type == LootSet.LootSetType.ARMOR_CHEST || type == LootSet.LootSetType.ARMOR_LEGS || type == LootSet.LootSetType.ARMOR_FEET) {
                    mlTag.func_74776_a("armor", case_rarity.getArmor(this.itemRand));
                    mlTag.func_74776_a("toughness", case_rarity.getToughness(this.itemRand));
                }
                int modifierCount = case_rarity.getModifierCount(this.itemRand);
                if (type == LootSet.LootSetType.RING && modifierCount == 0) {
                    modifierCount = 1;
                }
                if (type == LootSet.LootSetType.TOOL) {
                    if (--modifierCount < 0) {
                        modifierCount = 0;
                    }
                    if (case_rarity == LootRarity.EPIC && modifierCount == 0) {
                        modifierCount = 1;
                    }
                }
                boolean unbreakable = false;
                if (modifierCount > 0) {
                    ArrayList<LootWeaponEffect> appliedEffects = new ArrayList<LootWeaponEffect>();
                    NBTTagList effectList = new NBTTagList();
                    appliedEffects.add(LootWeaponEffect.ARMOR);
                    appliedEffects.add(LootWeaponEffect.TOUGHNESS);
                    for (int m = 0; m < modifierCount; ++m) {
                        LootWeaponEffect me = LootWeaponEffect.getRandomExcluding(this.itemRand, type, appliedEffects);
                        if (me == null) continue;
                        if (me == LootWeaponEffect.LIFE_LONG) {
                            unbreakable = true;
                        }
                        effectList.func_74742_a((NBTBase)me.getNBT(this.itemRand));
                        appliedEffects.add(me);
                    }
                    mlTag.func_74782_a("effectList", (NBTBase)effectList);
                }
                tag.func_74782_a("mysticTools", (NBTBase)mlTag);
                if (unbreakable) {
                    tag.func_74757_a("Unbreakable", true);
                }
                loot.func_77982_d(tag);
                LootItemHelper.setLootStringValue(loot, "loot_set", LootSet.getRandom(this.itemRand).getId());
                String loot_name = LootSet.getNameForType(type, this.itemRand);
                if (loot_name.length() > 0) {
                    LootItemHelper.setLootStringValue(loot, "loot_name", loot_name);
                }
                if (loot == null) continue;
                EnumFacing enumfacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)source);
                BehaviourLootCase.func_82486_a((World)source.func_82618_k(), (ItemStack)loot, (int)6, (EnumFacing)enumfacing, (IPosition)iposition);
                itemStack.func_190918_g(1);
            }
        }
        return itemStack;
    }
}

