/*
 * Decompiled with CFR 0.152.
 */
package binary404.MysticTools.block;

import binary404.MysticTools.Client.Colorizers;
import binary404.MysticTools.block.BlockEvolutionChamber;
import binary404.MysticTools.tileentity.IBlockTileEntity;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="mystictools")
public class Blocks {
    @GameRegistry.ObjectHolder(value="block_evolution_chamber")
    public static final Block EVOLUTION;
    private static final List<Block> BLOCKS;

    public static void initialize() {
    }

    private static Block initBlock(Block block, String id) {
        block.setRegistryName(new ResourceLocation("mystictools", id));
        block.func_149663_c(id);
        BLOCKS.add(block);
        return block;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        for (Block block : BLOCKS) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation("mystictools:" + block.func_149739_a().substring(5), "inventory"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        Blocks.registerColors(blockColors, itemColors, Colorizers.BLOCK_LEAVES, new Block[0]);
    }

    private static void registerColors(BlockColors blockColors, ItemColors itemColors, IBlockColor color, Block ... blocks) {
        blockColors.func_186722_a(color, blocks);
        itemColors.func_186731_a((s, t) -> color.func_186720_a(Block.func_149634_a((Item)s.func_77973_b()).func_176223_P(), null, null, t), blocks);
    }

    static {
        BLOCKS = new ArrayList<Block>();
        EVOLUTION = Blocks.initBlock((Block)new BlockEvolutionChamber(), "block_evolution_chamber");
    }

    @Mod.EventBusSubscriber(modid="mystictools")
    public static class BlockRegistry {
        public static final Set<ItemBlock> ITEM_BLOCKS = new HashSet<ItemBlock>();

        @SubscribeEvent
        public static void newRegistry(RegistryEvent.NewRegistry event) {
        }

        @SubscribeEvent
        public static void register(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.registerAll((IForgeRegistryEntry[])BLOCKS.toArray(new Block[0]));
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            for (Block block : BLOCKS) {
                ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
                ItemBlock item = new ItemBlock(block);
                registry.register(item.setRegistryName(registryName));
                if (block instanceof IBlockTileEntity) {
                    ((IBlockTileEntity)block).registerTileEntity();
                }
                ITEM_BLOCKS.add(item);
            }
        }
    }
}

