/*
 * Decompiled with CFR 0.152.
 */
package binary404.MysticTools.item;

import binary404.MysticTools.loot.LootSet;
import binary404.MysticTools.loot.item.ItemArmorMysticTools;
import binary404.MysticTools.loot.item.ItemBauble;
import binary404.MysticTools.loot.item.ItemShard;
import binary404.MysticTools.loot.item.ItemToolAxe;
import binary404.MysticTools.loot.item.ItemToolPickaxe;
import binary404.MysticTools.loot.item.ItemToolShovel;
import binary404.MysticTools.loot.item.ItemTypeRegistry;
import binary404.MysticTools.loot.item.ItemWeaponBow;
import binary404.MysticTools.loot.item.ItemWeaponCase;
import binary404.MysticTools.loot.item.ItemWeaponSword;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="mystictools")
public class MysticToolsItems {
    @GameRegistry.ObjectHolder(value="weaponcase")
    public static final Item WEAPONCASE;
    @GameRegistry.ObjectHolder(value="mystictools:shard")
    public static final Item SHARD;
    @GameRegistry.ObjectHolder(value="weaponsword")
    public static final Item WEAPONSWORD;
    @GameRegistry.ObjectHolder(value="baublering")
    public static final Item BAUBLERING;
    @GameRegistry.ObjectHolder(value="armor_boots")
    public static final Item ARMOR_BOOTS;
    @GameRegistry.ObjectHolder(value="armor_leggings")
    public static final Item ARMOR_LEGGINGS;
    @GameRegistry.ObjectHolder(value="armor_chestplate")
    public static final Item ARMOR_CHESTPLATE;
    @GameRegistry.ObjectHolder(value="armor_helmet")
    public static final Item ARMOR_HELMET;
    @GameRegistry.ObjectHolder(value="tool_axe")
    public static final Item TOOL_AXE;
    @GameRegistry.ObjectHolder(value="tool_pickaxe")
    public static final Item TOOL_PICKAXE;
    @GameRegistry.ObjectHolder(value="tool_shovel")
    public static final Item TOOL_SHOVEL;
    @GameRegistry.ObjectHolder(value="weaponbow")
    public static final Item WEAPONBOW;
    private static final List<Item> ITEMS;

    public static void initialize() {
    }

    private static Item initItem(Item item, String id) {
        item.setRegistryName(new ResourceLocation("mystictools", id));
        item.func_77655_b(id);
        ITEMS.add(item);
        return item;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        for (Item item : ITEMS) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("mystictools:" + item.func_77658_a().substring(5), "inventory"));
        }
    }

    @Nullable
    public static LootSet.LootSetType getItemType(Item item) {
        return ItemTypeRegistry.get(item);
    }

    static {
        ITEMS = new ArrayList<Item>();
        WEAPONCASE = MysticToolsItems.initItem(new ItemWeaponCase(), "weaponcase");
        SHARD = MysticToolsItems.initItem(new ItemShard(), "shard");
        WEAPONSWORD = MysticToolsItems.initItem((Item)new ItemWeaponSword(), "weaponsword");
        WEAPONBOW = MysticToolsItems.initItem((Item)new ItemWeaponBow(), "weaponbow");
        BAUBLERING = MysticToolsItems.initItem(new ItemBauble(), "baublering");
        ARMOR_BOOTS = MysticToolsItems.initItem((Item)new ItemArmorMysticTools(EntityEquipmentSlot.FEET), "armor_boots");
        ARMOR_LEGGINGS = MysticToolsItems.initItem((Item)new ItemArmorMysticTools(EntityEquipmentSlot.LEGS), "armor_leggings");
        ARMOR_CHESTPLATE = MysticToolsItems.initItem((Item)new ItemArmorMysticTools(EntityEquipmentSlot.CHEST), "armor_chestplate");
        ARMOR_HELMET = MysticToolsItems.initItem((Item)new ItemArmorMysticTools(EntityEquipmentSlot.HEAD), "armor_helmet");
        TOOL_AXE = MysticToolsItems.initItem((Item)new ItemToolAxe(), "tool_axe");
        TOOL_PICKAXE = MysticToolsItems.initItem((Item)new ItemToolPickaxe(), "tool_pickaxe");
        TOOL_SHOVEL = MysticToolsItems.initItem((Item)new ItemToolShovel(), "tool_shovel");
        ItemTypeRegistry.register(WEAPONSWORD, LootSet.LootSetType.SWORD);
        ItemTypeRegistry.register(WEAPONBOW, LootSet.LootSetType.BOW);
        ItemTypeRegistry.register(BAUBLERING, LootSet.LootSetType.RING);
        ItemTypeRegistry.register(ARMOR_BOOTS, LootSet.LootSetType.ARMOR_FEET);
        ItemTypeRegistry.register(ARMOR_LEGGINGS, LootSet.LootSetType.ARMOR_LEGS);
        ItemTypeRegistry.register(ARMOR_CHESTPLATE, LootSet.LootSetType.ARMOR_CHEST);
        ItemTypeRegistry.register(ARMOR_HELMET, LootSet.LootSetType.ARMOR_HEAD);
        ItemTypeRegistry.register(TOOL_AXE, LootSet.LootSetType.TOOL);
        ItemTypeRegistry.register(TOOL_PICKAXE, LootSet.LootSetType.TOOL);
        ItemTypeRegistry.register(TOOL_SHOVEL, LootSet.LootSetType.TOOL);
    }

    @Mod.EventBusSubscriber(modid="mystictools")
    public static class ItemRegistry {
        public static final Set<Item> ITEM_REGISTRY = new HashSet<Item>();

        @SubscribeEvent
        public static void newRegistry(RegistryEvent.NewRegistry event) {
        }

        @SubscribeEvent
        public static void register(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            for (Item item : ITEMS) {
                registry.register((IForgeRegistryEntry)item);
                ITEM_REGISTRY.add(item);
            }
            MysticToolsItems.initialize();
        }
    }
}

