/*
 * Decompiled with CFR 0.152.
 */
package binary404.MysticTools.loot;

import binary404.MysticTools.loot.ILootEffectAction;
import binary404.MysticTools.loot.LootItemHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class LootEffectActionAutoSmelt
implements ILootEffectAction {
    @Override
    public void toggleAction(EntityPlayer player, ItemStack stack) {
        boolean active = false;
        if (stack == null) {
            return;
        }
        active = !LootItemHelper.getLootBooleanValue(stack, "effect_active");
        LootItemHelper.setLootBooleanValue(stack, "effect_active", active);
    }

    @Override
    public void handleHarvest(EntityPlayer player, ItemStack stack, List<ItemStack> drops) {
        boolean effectActive = LootItemHelper.getLootBooleanValue(stack, "effect_active");
        if (!effectActive) {
            return;
        }
        ArrayList<ItemStack> smelted = new ArrayList<ItemStack>();
        for (ItemStack drop : drops) {
            ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a(drop);
            if (smeltResult != null && smeltResult != ItemStack.field_190927_a) {
                smelted.add(smeltResult.func_77946_l());
                continue;
            }
            smelted.add(drop.func_77946_l());
        }
        drops.clear();
        drops.addAll(smelted);
    }

    @Override
    public ITextComponent modificationResponseMessage(EntityPlayer player, ItemStack stack) {
        boolean active = LootItemHelper.getLootBooleanValue(stack, "effect_active");
        String message = "[Mystic Tools]: ";
        message = message + stack.func_82833_r();
        message = message + TextFormatting.RESET;
        message = message + "'s ";
        message = message + I18n.func_74838_a((String)"weaponeffect.auto_smelt.name");
        message = message + ", has been set to: ";
        message = message + active;
        return new TextComponentString(message);
    }

    @Override
    public void handleUpdate(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
    }

    @Override
    public String getStatusString(ItemStack stack) {
        String status = "[Off]";
        if (LootItemHelper.getLootBooleanValue(stack, "effect_active")) {
            status = "[On]";
        }
        return status;
    }

    @Override
    public ActionResult<ItemStack> handleUse(ActionResult<ItemStack> defaultAction, World world, EntityPlayer player, EnumHand hand) {
        return defaultAction;
    }
}

