/*
 * Decompiled with CFR 0.152.
 */
package binary404.MysticTools.loot;

import binary404.MysticTools.item.MysticToolsItems;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.text.TextFormatting;

public class LootRarity {
    private static final Map<String, LootRarity> REGISTRY = new HashMap<String, LootRarity>();
    public static final LootRarity COMMON = LootRarity.get("Common", TextFormatting.WHITE, MysticToolsItems.SHARD).setDamage(6, 11).setSpeed(-3.1f, -2.399f).setArmor(0.0f, 1.0f).setToughness(0.0f, 0.0f).setEfficiency(5.0f, 12.0f).setDurability(100, 550).setUpgrades(0, 1);
    public static final LootRarity RARE = LootRarity.get("Rare", TextFormatting.YELLOW, MysticToolsItems.SHARD).setDamage(9, 15).setSpeed(-2.8f, -2.3f).setArmor(1.0f, 3.0f).setToughness(0.0f, 2.0f).setEfficiency(10.0f, 25.0f).setDurability(350, 1450).setModifierCount(1, 2).setUpgrades(0, 2);
    public static final LootRarity EPIC = LootRarity.get("Epic", TextFormatting.BLUE, MysticToolsItems.SHARD).setDamage(12, 28).setSpeed(-2.69999f, -2.1f).setArmor(2.0f, 5.0f).setToughness(1.0f, 5.0f).setEfficiency(15.0f, 40.0f).setDurability(850, 2500).setModifierCount(2, 4).setUpgrades(1, 3);
    public static final LootRarity LEGENDARY = LootRarity.get("LEGENDARY", TextFormatting.DARK_PURPLE, MysticToolsItems.SHARD).setDamage(16, 40).setSpeed(-2.0f, -1.5f).setArmor(3.0f, 7.0f).setToughness(2.0f, 6.0f).setEfficiency(20.56f, 56.05f).setDurability(1000, 4000).setModifierCount(3, 6).setUpgrades(2, 4);
    private final Item shardItem;
    private TextFormatting color = TextFormatting.WHITE;
    private int damageMin = 0;
    private int damageMax = 7;
    private float speedMin = 0.0f;
    private float speedMax = 1.0f;
    private float armorMin = 3.0f;
    private float armorMax = 10.0f;
    private float toughnessMin = 3.0f;
    private float tougnessMax = 10.0f;
    private float efficiencyMin = 1.0f;
    private float efficiencyMax = 1.0f;
    private int durabilityMin = 0;
    private int durabilityMax = 0;
    private int modifiersMin = 0;
    private int modifiersMax = 1;
    private int upgradesMin = 1;
    private int upgradesMax = 10;
    private String id;

    private LootRarity(Item shard) {
        this.shardItem = shard;
    }

    public Item getShardItem() {
        return this.shardItem;
    }

    public TextFormatting getColor() {
        return this.color;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public static LootRarity fromId(String id) {
        LootRarity r = null;
        if (REGISTRY.containsKey(id)) {
            r = REGISTRY.get(id);
        }
        return r;
    }

    protected LootRarity setModifierCount(int min, int max) {
        this.modifiersMin = min;
        this.modifiersMax = max;
        return this;
    }

    protected LootRarity setDurability(int min, int max) {
        this.durabilityMin = min;
        this.durabilityMax = max;
        return this;
    }

    protected LootRarity setDamage(int min, int max) {
        this.damageMin = min;
        this.damageMax = max;
        return this;
    }

    protected LootRarity setSpeed(float min, float max) {
        this.speedMin = min;
        this.speedMax = max;
        return this;
    }

    protected LootRarity setArmor(float min, float max) {
        this.armorMin = min;
        this.armorMax = max;
        return this;
    }

    protected LootRarity setToughness(float min, float max) {
        this.toughnessMin = min;
        this.tougnessMax = max;
        return this;
    }

    protected LootRarity setEfficiency(float min, float max) {
        this.efficiencyMin = min;
        this.efficiencyMax = max;
        return this;
    }

    protected LootRarity setUpgrades(int min, int max) {
        this.upgradesMin = min;
        this.upgradesMax = max;
        return this;
    }

    public int getModifierCount(Random rand) {
        int modifierCount = this.modifiersMin;
        if (modifierCount < this.modifiersMax) {
            modifierCount += rand.nextInt(this.modifiersMax - modifierCount + 1);
        }
        return modifierCount;
    }

    public int getDurability(Random rand) {
        int durability = this.durabilityMin;
        if (durability < this.durabilityMax) {
            durability += rand.nextInt(this.durabilityMax - durability + 1);
        }
        return durability;
    }

    public int getDamage(Random rand) {
        int damage = this.damageMin;
        if (damage < this.damageMax) {
            damage += rand.nextInt(this.damageMax - damage + 1);
        }
        return damage;
    }

    public float getSpeed(Random rand) {
        float speed = this.speedMin;
        speed += (this.speedMax - speed) * rand.nextFloat();
        return speed;
    }

    public float getArmor(Random rand) {
        float armor = this.armorMin;
        armor += (this.armorMax - armor) * rand.nextFloat();
        armor = (float)Math.round(armor * 100.0f) / 100.0f;
        return armor;
    }

    public float getToughness(Random rand) {
        float toughness = this.toughnessMin;
        toughness += (this.tougnessMax - toughness) * rand.nextFloat();
        toughness = (float)Math.round(toughness * 100.0f) / 100.0f;
        return toughness;
    }

    public float getEfficiency(Random rand) {
        float efficiency = this.efficiencyMin;
        efficiency += (this.efficiencyMax - efficiency) * rand.nextFloat();
        return efficiency;
    }

    public int getUpgrades(Random rand) {
        int upgrades = this.upgradesMin;
        upgrades += rand.nextInt(this.upgradesMax - upgrades + 1);
        return upgrades;
    }

    protected static LootRarity get(String id, TextFormatting color, Item shard) {
        LootRarity r = new LootRarity(shard);
        r.id = id;
        r.color = color;
        REGISTRY.put(id, r);
        return r;
    }
}

