/*
 * Decompiled with CFR 0.152.
 */
package binary404.MysticTools.loot;

import binary404.MysticTools.loot.ILootEffectAction;
import binary404.MysticTools.loot.LootEffectActionAreaMiner;
import binary404.MysticTools.loot.LootEffectActionAutoSmelt;
import binary404.MysticTools.loot.LootEffectActionEat;
import binary404.MysticTools.loot.LootEffectActionMagnet;
import binary404.MysticTools.loot.LootEffectActionSleep;
import binary404.MysticTools.loot.LootEffectActionVoid;
import binary404.MysticTools.loot.LootItemHelper;
import binary404.MysticTools.loot.LootSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;

public class LootWeaponEffect {
    public static final Map<String, LootWeaponEffect> REGISTRY = new HashMap<String, LootWeaponEffect>();
    public static final LootWeaponEffect WITHERING = LootWeaponEffect.create("wither", EffectType.PASSIVE, MobEffects.field_82731_v).setDuration(1, 2).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
    public static final LootWeaponEffect POISON = LootWeaponEffect.create("poison", EffectType.PASSIVE, MobEffects.field_76436_u).setDuration(1, 3).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
    public static final LootWeaponEffect HUNGER = LootWeaponEffect.create("hunger", EffectType.PASSIVE, MobEffects.field_76438_s).setDuration(1, 10).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
    public static final LootWeaponEffect LEVITATION = LootWeaponEffect.create("levitation", EffectType.PASSIVE, MobEffects.field_188424_y).setDuration(1, 3).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
    public static final LootWeaponEffect WEAKNESS = LootWeaponEffect.create("weakness", EffectType.PASSIVE, MobEffects.field_76437_t).setDuration(1, 3).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
    public static final LootWeaponEffect SLOWNESS = LootWeaponEffect.create("slowness", EffectType.PASSIVE, MobEffects.field_76421_d).setDuration(1, 3).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
    public static final LootWeaponEffect BLINDNESS = LootWeaponEffect.create("blindness", EffectType.PASSIVE, MobEffects.field_76440_q).setDuration(1, 2).setItemTypes(LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
    public static final LootWeaponEffect LEECHLIFE = LootWeaponEffect.create("leechlife", EffectType.PASSIVE).setAmplifier(1, 100).setItemTypes(LootSet.LootSetType.SWORD);
    public static final LootWeaponEffect LIGHTNING = LootWeaponEffect.create("lightning", EffectType.PASSIVE).setItemTypes(LootSet.LootSetType.SWORD);
    public static final LootWeaponEffect MULTISHOT = LootWeaponEffect.create("multishot", EffectType.PASSIVE).setAmplifier(2, 6).setItemTypes(LootSet.LootSetType.BOW);
    public static final LootWeaponEffect SPEED = LootWeaponEffect.create("speed", EffectType.PASSIVE, MobEffects.field_76424_c).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.RING);
    public static final LootWeaponEffect STRENGTH = LootWeaponEffect.create("strength", EffectType.PASSIVE, MobEffects.field_76420_g).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.RING);
    public static final LootWeaponEffect JUMP = LootWeaponEffect.create("jump", EffectType.PASSIVE, MobEffects.field_76430_j).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.RING);
    public static final LootWeaponEffect RESISTANCE = LootWeaponEffect.create("resistance", EffectType.PASSIVE, MobEffects.field_76429_m).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.RING);
    public static final LootWeaponEffect HASTE = LootWeaponEffect.create("haste", EffectType.PASSIVE, MobEffects.field_76422_e).setAmplifier(0, 1).setItemTypes(LootSet.LootSetType.RING, LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect FIRE_RESISTANT = LootWeaponEffect.create("fire_resistance", EffectType.PASSIVE, MobEffects.field_76426_n).setItemTypes(LootSet.LootSetType.RING, LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect REGENERATION = LootWeaponEffect.create("regeneration", EffectType.PASSIVE, MobEffects.field_76428_l).setItemTypes(LootSet.LootSetType.RING, LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect HEALTH_BOOST = LootWeaponEffect.create("healthboost", EffectType.PASSIVE, SharedMonsterAttributes.field_111267_a).setAmplifier(1, 4).setItemTypes(LootSet.LootSetType.ARMOR_HEAD, LootSet.LootSetType.ARMOR_CHEST, LootSet.LootSetType.ARMOR_LEGS, LootSet.LootSetType.ARMOR_FEET);
    public static final LootWeaponEffect KNOCKBACK_RESISTANCE = LootWeaponEffect.create("knockbackresistance", EffectType.PASSIVE, SharedMonsterAttributes.field_111266_c).setAmplifier(1, 1).setItemTypes(LootSet.LootSetType.ARMOR_CHEST, LootSet.LootSetType.ARMOR_LEGS);
    public static final LootWeaponEffect LUCK = LootWeaponEffect.create("luck", EffectType.PASSIVE, SharedMonsterAttributes.field_188792_h).setAmplifier(1, 50).setItemTypes(LootSet.LootSetType.ARMOR_HEAD);
    public static final LootWeaponEffect TOXIC = LootWeaponEffect.create("toxic", EffectType.PASSIVE).setItemTypes(LootSet.LootSetType.ARMOR_LEGS, LootSet.LootSetType.ARMOR_HEAD, LootSet.LootSetType.ARMOR_FEET, LootSet.LootSetType.ARMOR_CHEST).setAmplifier(0, 5).setDuration(100, 500);
    public static final LootWeaponEffect ARMOR = LootWeaponEffect.create("armor", EffectType.PASSIVE, SharedMonsterAttributes.field_188791_g).setAmplifier(3, 10).setItemTypes(LootSet.LootSetType.ARMOR_HEAD, LootSet.LootSetType.ARMOR_CHEST, LootSet.LootSetType.ARMOR_LEGS, LootSet.LootSetType.ARMOR_FEET);
    public static final LootWeaponEffect TOUGHNESS = LootWeaponEffect.create("armor_toughness", EffectType.PASSIVE, SharedMonsterAttributes.field_189429_h).setAmplifier(3, 6).setItemTypes(LootSet.LootSetType.ARMOR_HEAD, LootSet.LootSetType.ARMOR_CHEST, LootSet.LootSetType.ARMOR_LEGS, LootSet.LootSetType.ARMOR_FEET);
    public static final LootWeaponEffect LIFE_LONG = LootWeaponEffect.create("life_long", EffectType.PASSIVE).setItemTypes(LootSet.LootSetType.TOOL, LootSet.LootSetType.SWORD, LootSet.LootSetType.BOW);
    public static final LootWeaponEffect NIGHT_VISION = LootWeaponEffect.create("night_vision", EffectType.PASSIVE, MobEffects.field_76439_r).setItemTypes(LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect INVISIBILITY = LootWeaponEffect.create("invisibility", EffectType.PASSIVE, MobEffects.field_76441_p).setItemTypes(LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect AUTO_SMELT = LootWeaponEffect.create("auto_smelt", EffectType.ACTIVE).setItemTypes(LootSet.LootSetType.TOOL).setAction(new LootEffectActionAutoSmelt());
    public static final LootWeaponEffect AREA_MINER = LootWeaponEffect.create("area_miner", EffectType.ACTIVE).setItemTypes(LootSet.LootSetType.TOOL).setAction(new LootEffectActionAreaMiner());
    public static final LootWeaponEffect VOID = LootWeaponEffect.create("void", EffectType.ACTIVE).setItemTypes(LootSet.LootSetType.TOOL).setAction(new LootEffectActionVoid());
    public static final LootWeaponEffect MAGNETIC = LootWeaponEffect.create("magnetic", EffectType.PASSIVE).setItemTypes(LootSet.LootSetType.TOOL).setAction(new LootEffectActionMagnet());
    public static final LootWeaponEffect MULTI = LootWeaponEffect.create("multi", EffectType.PASSIVE).setItemTypes(LootSet.LootSetType.TOOL);
    public static final LootWeaponEffect TASTY = LootWeaponEffect.create("tasty", EffectType.USE).setItemTypes(LootSet.LootSetType.TOOL).setAction(new LootEffectActionEat());
    public static final LootWeaponEffect SLEEP = LootWeaponEffect.create("sleep", EffectType.USE).setItemTypes(LootSet.LootSetType.TOOL).setAction(new LootEffectActionSleep());
    public static final LootWeaponEffect JETPACK = LootWeaponEffect.create("jetpack", EffectType.PASSIVE).setItemTypes(LootSet.LootSetType.ARMOR_CHEST).setAmplifier(5, 20).setDuration(2, 5);
    private String id;
    private Potion effect;
    private IAttribute attribute;
    private int durationMin = 100;
    private int durationMax = 300;
    private int amplifierMin = 0;
    private int amplifierMax = 0;
    private List<LootSet.LootSetType> applyToItems = new ArrayList<LootSet.LootSetType>();
    private ILootEffectAction action;
    private final EffectType effectType;

    private LootWeaponEffect(EffectType type) {
        this.effectType = type;
    }

    public EffectType getType() {
        return this.effectType;
    }

    public boolean applyToItemType(LootSet.LootSetType type) {
        return this.applyToItems.contains((Object)type);
    }

    public ILootEffectAction getAction() {
        return this.action;
    }

    protected LootWeaponEffect setAction(ILootEffectAction action) {
        this.action = action;
        return this;
    }

    protected LootWeaponEffect setItemTypes(LootSet.LootSetType ... itemTypes) {
        for (LootSet.LootSetType itemType : itemTypes) {
            this.applyToItems.add(itemType);
        }
        return this;
    }

    public static LootWeaponEffect getById(String id) {
        LootWeaponEffect weaponEffect = REGISTRY.get(id);
        return weaponEffect;
    }

    public String getId() {
        return this.id;
    }

    public static LootWeaponEffect getRandomExcluding(Random rand, LootSet.LootSetType type, List<LootWeaponEffect> exclude) {
        LootWeaponEffect weaponEffect = null;
        boolean hasActive = false;
        boolean hasUse = false;
        for (LootWeaponEffect ex : exclude) {
            if (ex.getType() == EffectType.ACTIVE) {
                hasActive = true;
            }
            if (ex.getType() != EffectType.USE) continue;
            hasUse = true;
        }
        ArrayList<LootWeaponEffect> list = new ArrayList<LootWeaponEffect>();
        for (LootWeaponEffect e : REGISTRY.values()) {
            if (!e.applyToItemType(type) || hasActive && e.getType() == EffectType.ACTIVE || hasUse && e.getType() == EffectType.USE) continue;
            list.add(e);
        }
        list.removeAll(exclude);
        if (list.size() > 0) {
            weaponEffect = (LootWeaponEffect)list.get(rand.nextInt(list.size()));
        }
        return weaponEffect;
    }

    public NBTTagCompound getNBT(Random rand) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("id", this.getId());
        tag.func_74768_a("duration", this.getDuration(rand));
        tag.func_74768_a("amplifier", this.getAmplifier(rand));
        return tag;
    }

    public static int getDurationFromStack(ItemStack stack, String effectId) {
        int duration = 0;
        NBTTagList effectTagList = LootItemHelper.getLootTagList(stack, "effectList");
        int count = effectTagList.func_74745_c();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound e = effectTagList.func_150305_b(i);
            if (!e.func_74779_i("id").contains(effectId)) continue;
            duration = e.func_74762_e("duration");
        }
        return duration;
    }

    public static int getAmplifierFromStack(ItemStack stack, String effectId) {
        int amplifier = 0;
        NBTTagList effectTagList = LootItemHelper.getLootTagList(stack, "effectList");
        int count = effectTagList.func_74745_c();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound e = effectTagList.func_150305_b(i);
            if (!e.func_74779_i("id").contains(effectId)) continue;
            amplifier = e.func_74762_e("amplifier");
        }
        return amplifier;
    }

    public static List<LootWeaponEffect> getEffectList(ItemStack stack) {
        ArrayList<LootWeaponEffect> list = new ArrayList<LootWeaponEffect>();
        NBTTagList effectTagList = LootItemHelper.getLootTagList(stack, "effectList");
        int count = effectTagList.func_74745_c();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound e = effectTagList.func_150305_b(i);
            list.add(LootWeaponEffect.getById(e.func_74779_i("id")));
        }
        return list;
    }

    protected static LootWeaponEffect create(String id, EffectType type) {
        return LootWeaponEffect.create(id, type, null, null);
    }

    protected static LootWeaponEffect create(String id, EffectType type, IAttribute attribute) {
        return LootWeaponEffect.create(id, type, null, attribute);
    }

    protected static LootWeaponEffect create(String id, EffectType type, Potion effect) {
        return LootWeaponEffect.create(id, type, effect, null);
    }

    protected static LootWeaponEffect create(String id, EffectType type, Potion effect, IAttribute attribute) {
        LootWeaponEffect weaponEffect = new LootWeaponEffect(type);
        weaponEffect.id = id;
        weaponEffect.effect = effect;
        weaponEffect.attribute = attribute;
        REGISTRY.put(id, weaponEffect);
        return weaponEffect;
    }

    protected LootWeaponEffect setDuration(int min, int max) {
        this.durationMin = min * 100;
        this.durationMax = max * 100;
        return this;
    }

    protected LootWeaponEffect setAmplifier(int min, int max) {
        this.amplifierMin = min;
        this.amplifierMax = max;
        return this;
    }

    private int getDuration(Random rand) {
        int duration = this.durationMin;
        if (duration < this.durationMax) {
            duration += rand.nextInt(this.durationMax - duration + 1);
        }
        return duration;
    }

    private int getAmplifier(Random rand) {
        int amplifier = this.amplifierMin;
        if (amplifier < this.amplifierMax) {
            amplifier += rand.nextInt(this.amplifierMax - amplifier + 1);
        }
        return amplifier;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    public PotionEffect getPotionEffect(int duration, int amplifier) {
        if (this.effect == null) {
            return null;
        }
        PotionEffect weaponEffect = new PotionEffect(this.effect, duration, amplifier, true, false);
        return weaponEffect;
    }

    public void onHit(int duration, int amplifier, EntityLivingBase target, EntityLivingBase attacker) {
        PotionEffect effect = this.getPotionEffect(duration, amplifier);
        if (effect != null) {
            target.func_70690_d(effect);
        }
    }

    public String getAmplifierString(ItemStack stack, String effectId) {
        return this.getAmplifierString(stack, effectId, 0);
    }

    public String getAmplifierString(ItemStack stack, String effectId, int add) {
        return TextFormatting.BOLD + "" + (LootWeaponEffect.getAmplifierFromStack(stack, effectId) + add) + "" + TextFormatting.RESET + "" + (this.getType() == EffectType.PASSIVE ? TextFormatting.GREEN : TextFormatting.GOLD) + "";
    }

    public String getDurationString(ItemStack stack, String effectId) {
        return TextFormatting.BOLD + "" + LootWeaponEffect.getDurationFromStack(stack, effectId) / 100 + "" + TextFormatting.RESET + "" + TextFormatting.GREEN + "";
    }

    public String getActionStatus(ItemStack stack) {
        String statusString = "";
        if (this.getAction() != null) {
            statusString = this.getAction().getStatusString(stack);
        }
        return statusString;
    }

    public static enum EffectType {
        ACTIVE(TextFormatting.GOLD),
        PASSIVE(TextFormatting.GREEN),
        USE(TextFormatting.AQUA);

        private TextFormatting color;

        private EffectType(TextFormatting color) {
            this.color = color;
        }

        public TextFormatting getColor() {
            return this.color;
        }

        public boolean equals(EffectType type) {
            return type == this;
        }
    }
}

