/*
 * Decompiled with CFR 0.152.
 */
package binary404.MysticTools.loot.item;

import binary404.MysticTools.loot.LootItemHelper;
import binary404.MysticTools.loot.LootWeaponEffect;
import binary404.MysticTools.loot.item.IMysticTool;
import binary404.MysticTools.loot.item.ItemMysticTool;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemToolAxe
extends ItemAxe
implements IMysticTool {
    public ItemToolAxe() {
        super(Item.ToolMaterial.DIAMOND);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("model"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float model = 1.0f;
                model = LootItemHelper.getLootIntValue(stack, "model");
                return model;
            }
        });
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public String func_77653_i(ItemStack stack) {
        return ItemMysticTool.getMegaLootDisplayName(stack, super.func_77653_i(stack));
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        RayTraceResult raytrace;
        boolean onbreak = false;
        if (LootItemHelper.hasEffect(itemstack, LootWeaponEffect.AREA_MINER) && LootItemHelper.getLootIntValue(itemstack, "effect_level") > 1 && (raytrace = ItemMysticTool.getBlockOnReach(player.field_70170_p, player)) != null) {
            int level = LootItemHelper.getLootIntValue(itemstack, "effect_level");
            onbreak = ItemMysticTool.breakBlocks(itemstack, level, player.field_70170_p, pos, raytrace.field_178784_b, player);
        }
        return onbreak;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof EntityPlayer && isSelected) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemMysticTool.applyEffects(stack, player, itemSlot, isSelected);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ActionResult<ItemStack> defaultAction = super.func_77659_a(world, player, hand);
        defaultAction = ItemMysticTool.use(defaultAction, world, player, hand);
        return defaultAction;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = ItemMysticTool.modifiersForStack(slot, stack, (Multimap<String, AttributeModifier>)super.getAttributeModifiers(slot, stack), "Tool modifier");
        return multimap;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return ItemMysticTool.getEfficiency(stack, state);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        if (LootItemHelper.hasEffect(stack, LootWeaponEffect.MULTI)) {
            return Sets.newHashSet((Object[])new String[]{"axe", "pickaxe", "shovel"});
        }
        return super.getToolClasses(stack);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        boolean canHarvest = super.canHarvestBlock(state, stack);
        if (LootItemHelper.hasEffect(stack, LootWeaponEffect.MULTI)) {
            return true;
        }
        return canHarvest;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (LootItemHelper.hasEffect(stack, LootWeaponEffect.MULTI)) {
            return 3;
        }
        return super.getHarvestLevel(stack, toolClass, player, blockState);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (GuiScreen.func_146272_n()) {
            LootItemHelper.addInformation(stack, tooltip);
        } else {
            tooltip.add(TextFormatting.RESET + "Axe");
            float efficiency = LootItemHelper.getLootFloatValue(stack, "efficiency");
            tooltip.add(TextFormatting.GRAY + "" + ItemStack.field_111284_a.format(efficiency) + " Mining Speed");
            tooltip.add(TextFormatting.AQUA + "" + TextFormatting.ITALIC + "Shift" + TextFormatting.DARK_GRAY + " for more...");
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        boolean hit = super.func_77644_a(stack, target, attacker);
        ItemMysticTool.handleEffectsAfterHit(stack, target, attacker);
        return hit;
    }

    public int getMaxDamage(ItemStack stack) {
        return LootItemHelper.getMaxDamage(stack);
    }
}

