/*
 * Decompiled with CFR 0.152.
 */
package binary404.MysticTools.loot.item;

import binary404.MysticTools.MysticTools;
import binary404.MysticTools.item.MysticToolsItems;
import binary404.MysticTools.loot.LootItemHelper;
import binary404.MysticTools.loot.LootWeaponEffect;
import binary404.MysticTools.loot.item.IMysticTool;
import binary404.MysticTools.loot.item.ItemMysticTool;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWeaponBow
extends ItemBow
implements IMysticTool {
    public ItemWeaponBow() {
        this.func_77637_a(MysticTools.creativeTab);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("model"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float model = 1.0f;
                model = LootItemHelper.getLootIntValue(stack, "model");
                return model;
            }
        });
        this.func_185043_a(new ResourceLocation("ml_pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                float pull = 0.0f;
                if (entity == null) {
                    return pull;
                }
                ItemStack itemstack = entity.func_184607_cu();
                pull = itemstack != null && itemstack.func_77973_b() == MysticToolsItems.WEAPONBOW ? (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f : 0.0f;
                return pull;
            }
        });
        this.func_185043_a(new ResourceLocation("ml_pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public String func_77653_i(ItemStack stack) {
        return ItemMysticTool.getMegaLootDisplayName(stack, super.func_77653_i(stack));
    }

    public int func_77619_b() {
        return Item.ToolMaterial.GOLD.func_77995_e();
    }

    public int getMaxDamage(ItemStack stack) {
        return LootItemHelper.getMaxDamage(stack);
    }

    @Nullable
    protected ItemStack func_185060_a(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemStack = player.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemStack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)(flag = this.func_185060_a(player) != null));
        if (ret != null) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !flag) {
            return !flag ? new ActionResult(EnumActionResult.FAIL, (Object)itemStack) : new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        player.func_184598_c(hand);
        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = this.func_185060_a(entityplayer);
            int time = this.func_77626_a(stack) - timeLeft;
            if ((time = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)time, (itemstack != null || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (itemstack != null || flag) {
                if (itemstack == null) {
                    itemstack = new ItemStack(Items.field_151032_g);
                }
                float f = ItemWeaponBow.func_185059_b((int)time);
                float draw_factor = LootItemHelper.getLootFloatValue(stack, "drawspeed");
                if (draw_factor > 0.0f) {
                    f *= draw_factor;
                }
                if ((double)f < 0.1) {
                    return;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
                int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
                int m = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack);
                List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(stack);
                int s = 1;
                if (effects.contains(LootWeaponEffect.getById("multishot"))) {
                    s = LootWeaponEffect.getAmplifierFromStack(stack, "multishot");
                }
                if (s == 0) {
                    s = 1;
                }
                boolean flag1 = entityplayer.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemArrow && ((ItemArrow)itemstack.func_77973_b()).isInfinite(itemstack, stack, entityplayer);
                for (int i = 0; i < s && !world.field_72995_K; ++i) {
                    ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                    EntityArrow entityarrow = itemarrow.func_185052_a(world, itemstack, (EntityLivingBase)entityplayer);
                    if (effects.size() > 0) {
                        EntityTippedArrow tippedArrow = entityarrow instanceof EntityTippedArrow ? (EntityTippedArrow)entityarrow : new EntityTippedArrow(world, (EntityLivingBase)entityplayer);
                        for (LootWeaponEffect effect : effects) {
                            PotionEffect potionEffect = effect.getPotionEffect(LootWeaponEffect.getDurationFromStack(stack, effect.getId()), LootWeaponEffect.getAmplifierFromStack(stack, effect.getId()));
                            if (potionEffect == null) continue;
                            tippedArrow.func_184558_a(potionEffect);
                        }
                        entityarrow = tippedArrow;
                        entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                    }
                    entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    if (f == 1.0f) {
                        entityarrow.func_70243_d(true);
                    }
                    if (j > 0) {
                        entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                    }
                    if (k > 0) {
                        entityarrow.func_70240_a(k);
                    }
                    if (m > 0) {
                        entityarrow.func_70015_d(100);
                    }
                    entityarrow.func_70239_b(entityarrow.func_70242_d() * (double)LootItemHelper.getLootFloatValue(stack, "power"));
                    stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                    if (flag1 || i > 0) {
                        entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                    }
                    world.func_72838_d((Entity)entityarrow);
                }
                world.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                if (!flag1) {
                    itemstack.func_190918_g(1);
                    if (itemstack.func_190926_b()) {
                        entityplayer.field_71071_by.func_184437_d(itemstack);
                    }
                }
                entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (GuiScreen.func_146272_n()) {
            LootItemHelper.addInformation(stack, tooltip);
        } else {
            tooltip.add(TextFormatting.RESET + "Bow");
            tooltip.add(TextFormatting.GRAY + "Draw speed modifier " + TextFormatting.BOLD + "" + ItemStack.field_111284_a.format(LootItemHelper.getLootFloatValue(stack, "drawspeed")));
            tooltip.add("Power multiplier " + TextFormatting.BOLD + "" + ItemStack.field_111284_a.format(LootItemHelper.getLootFloatValue(stack, "power")));
            tooltip.add(TextFormatting.AQUA + "" + TextFormatting.ITALIC + "Shift" + TextFormatting.DARK_GRAY + " for more...");
        }
    }

    public boolean updatesFOV() {
        return true;
    }

    public int getFOVDuration(ItemStack stack) {
        float drawSpeed = LootItemHelper.getLootFloatValue(stack, "drawspeed");
        return (int)(10000.0f / drawSpeed);
    }

    public float getFOVValue(ItemStack stack) {
        float drawSpeed = LootItemHelper.getLootFloatValue(stack, "drawspeed");
        return 0.4f * (drawSpeed * 1.3f);
    }

    public float getFOVSpeedFactor(ItemStack stack) {
        return 350.0f;
    }
}

