/*
 * Decompiled with CFR 0.152.
 */
package binary404.MysticTools.tileentity;

import binary404.MysticTools.item.MysticToolsItems;
import binary404.MysticTools.loot.LootItemHelper;
import binary404.MysticTools.loot.LootRarity;
import binary404.MysticTools.loot.LootSet;
import binary404.MysticTools.loot.item.IMysticTool;
import binary404.MysticTools.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityEvolutionChamber
extends TileEntityBase
implements ISidedInventory,
ITickable {
    public static final int TOTAL_EVOLUTION_TIME = 10;
    private static final int[] top = new int[]{0, 1};
    private static final int[] sides = new int[]{2, 3};
    private ItemStack[] chestContents = new ItemStack[2];
    private int tick = 0;
    private int evolution_time = 0;
    private List<EntityPlayer> playersAround;

    public void gatherPlayers() {
        this.playersAround = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(3, 3, 3), this.field_174879_c.func_177982_a(-3, -3, -3)));
    }

    private boolean canInfuse() {
        ItemStack upgradable = this.func_70301_a(0);
        ItemStack shard = this.func_70301_a(1);
        if (upgradable.func_77973_b() == MysticToolsItems.WEAPONCASE) {
            return true;
        }
        if (upgradable.func_77973_b() instanceof IMysticTool) {
            return true;
        }
        if (upgradable.func_190926_b()) {
            return false;
        }
        if (!shard.func_190926_b() && shard.func_190916_E() >= shard.func_77976_d()) {
            return false;
        }
        return false;
    }

    @Override
    public void func_73660_a() {
        block22: {
            block25: {
                block24: {
                    ItemStack upgradable;
                    block23: {
                        this.tick = (this.tick + 1) % 20;
                        this.gatherPlayers();
                        if (this.tick != 0) break block22;
                        upgradable = this.func_70301_a(0);
                        if (!upgradable.func_190926_b()) break block23;
                        this.evolution_time = 0;
                        break block22;
                    }
                    if (!this.canInfuse()) break block24;
                    ++this.evolution_time;
                    if (this.evolution_time <= 10) break block25;
                    boolean chance = false;
                    ItemStack failed = ItemStack.field_190927_a;
                    ItemStack success = ItemStack.field_190927_a;
                    int amount = this.field_145850_b.field_73012_v.nextInt(10) + 1;
                    int shardCount = 4 + this.field_145850_b.field_73012_v.nextInt(8);
                    if (upgradable.func_77973_b() == MysticToolsItems.WEAPONCASE) {
                        success = new ItemStack(MysticToolsItems.SHARD, amount);
                        if (!success.func_190926_b()) {
                            ItemStack shard = this.func_70301_a(1);
                            if (shard.func_190926_b()) {
                                this.func_70299_a(1, success);
                                upgradable.func_190918_g(1);
                            } else if (success.func_77969_a(shard) && shard.func_190916_E() < shard.func_77976_d()) {
                                shard.func_190917_f(amount);
                                upgradable.func_190918_g(1);
                            }
                        }
                        this.updateInWorld();
                        this.evolution_time = 0;
                    } else if (upgradable.func_77973_b() instanceof IMysticTool) {
                        LootRarity rarity = LootRarity.fromId(LootItemHelper.getLootStringValue(upgradable, "rarity"));
                        success = rarity == LootRarity.COMMON ? new ItemStack(MysticToolsItems.SHARD, amount) : (rarity == LootRarity.RARE ? new ItemStack(MysticToolsItems.SHARD, (int)((double)amount * 1.5)) : (rarity == LootRarity.EPIC ? new ItemStack(MysticToolsItems.SHARD, amount * 2) : (rarity == LootRarity.LEGENDARY ? new ItemStack(MysticToolsItems.SHARD, (int)((double)amount * 2.5)) : new ItemStack(MysticToolsItems.SHARD, amount))));
                        int model = LootItemHelper.getLootIntValue(upgradable, "model");
                        if (!this.playersAround.isEmpty()) {
                            for (EntityPlayer disenchanterPlayer : this.playersAround) {
                                int[] modelList;
                                NBTTagCompound playerTag = disenchanterPlayer.getEntityData();
                                if (playerTag == null) continue;
                                NBTTagCompound playerLootTag = playerTag.func_74764_b("mystictools") ? playerTag.func_74775_l("mystictools") : new NBTTagCompound();
                                NBTTagCompound skinTag = playerLootTag.func_74764_b("loot_skins") ? playerLootTag.func_74775_l("loot_skins") : new NBTTagCompound();
                                LootSet.LootSetType type = MysticToolsItems.getItemType(upgradable.func_77973_b());
                                String classKey = type.getId();
                                if (classKey == "tool") {
                                    if (upgradable.func_77973_b() instanceof ItemPickaxe) {
                                        classKey = "pickaxe";
                                    }
                                    if (upgradable.func_77973_b() instanceof ItemAxe) {
                                        classKey = "axe";
                                    }
                                    if (upgradable.func_77973_b() instanceof ItemSpade) {
                                        classKey = "shovel";
                                    }
                                }
                                if ((modelList = skinTag.func_74759_k(classKey)) == null || modelList.length == 0) {
                                    modelList = new int[]{model};
                                } else {
                                    ArrayList<Integer> ml = new ArrayList<Integer>();
                                    for (int m : modelList) {
                                        ml.add(m);
                                    }
                                    if (!ml.contains(model)) {
                                        ml.add(model);
                                    }
                                    modelList = ml.stream().mapToInt(i -> i).toArray();
                                }
                                skinTag.func_74783_a(classKey, modelList);
                                playerLootTag.func_74782_a("loot_skins", (NBTBase)skinTag);
                                playerTag.func_74782_a("mystictools", (NBTBase)playerLootTag);
                            }
                        }
                        if (!success.func_190926_b()) {
                            ItemStack shard = this.func_70301_a(1);
                            if (shard.func_190926_b()) {
                                this.func_70299_a(1, success);
                                upgradable.func_190918_g(1);
                            } else if (success.func_77969_a(shard) && shard.func_190916_E() < shard.func_77976_d()) {
                                shard.func_190917_f(amount);
                                upgradable.func_190918_g(1);
                            }
                        }
                        this.updateInWorld();
                        this.evolution_time = 0;
                    } else {
                        success = null;
                        this.updateInWorld();
                        this.evolution_time = 0;
                    }
                    break block22;
                }
                this.evolution_time = 0;
                this.updateInWorld();
                break block22;
            }
            this.updateInWorld();
        }
    }

    private void updateInWorld() {
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 0);
    }

    public int getEvolutionTime() {
        return this.evolution_time;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound c = super.func_189515_b(compound);
        compound.func_74768_a("evolution_time", this.evolution_time);
        return c;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.evolution_time = compound.func_74762_e("evolution_time");
        super.func_145839_a(compound);
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public ItemStack[] getChestContents() {
        return this.chestContents;
    }

    @Override
    public void setChestContents(ItemStack[] contents) {
        this.chestContents = contents;
    }

    @Override
    public int getSlotXOffset() {
        return 0;
    }

    @Override
    public int getSlotYOffset() {
        return 0;
    }

    @Override
    public Slot getSlot(IInventory inv, int index, int x, int y) {
        Slot slot = new Slot(inv, index, x, y);
        return slot;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTextures() {
        return null;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        NonNullList items = NonNullList.func_191196_a();
        for (ItemStack stack : this.chestContents) {
            items.add((Object)(stack == null ? ItemStack.field_190927_a : stack));
        }
        return items;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new SidedInvWrapper((ISidedInventory)this, side));
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new InvWrapper((IInventory)this));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return !stack.func_190926_b();
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return top;
        }
        return sides;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 0 && side != EnumFacing.UP || slot == 1 && side != EnumFacing.UP;
    }
}

