/*
 * Decompiled with CFR 0.152.
 */
package binary404.MysticTools.tileentity;

import binary404.MysticTools.item.MysticToolsItems;
import binary404.MysticTools.loot.LootItemHelper;
import binary404.MysticTools.loot.LootRarity;
import binary404.MysticTools.loot.LootSet;
import binary404.MysticTools.loot.LootWeaponEffect;
import binary404.MysticTools.loot.item.ItemShard;
import binary404.MysticTools.tileentity.TileEntityBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityUpgrader
extends TileEntityBase {
    private ItemStack[] chestContents = new ItemStack[3];
    private final int disenchantStepDuration = 50;
    private int disenchantCounter = 0;
    private int disenchantStep = 0;
    private boolean disenchaning = false;
    private int tick = 0;
    private EntityPlayer disenchanterPlayer;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    public void setDisenchanterPlayer(EntityPlayer disenchanter) {
        this.disenchanterPlayer = disenchanter;
    }

    public int getDisenchantStep() {
        return this.disenchantStep;
    }

    @Override
    public ItemStack[] getChestContents() {
        return this.chestContents;
    }

    @Override
    public void setChestContents(ItemStack[] contents) {
        this.chestContents = contents;
    }

    @Override
    public int getSlotXOffset() {
        return 0;
    }

    @Override
    public int getSlotYOffset() {
        return 0;
    }

    @Override
    public Slot getSlot(IInventory inv, int index, int x, int y) {
        Slot slot = new Slot(inv, index, x, y);
        return slot;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTextures() {
        return null;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        NonNullList items = NonNullList.func_191196_a();
        for (ItemStack stack : this.chestContents) {
            items.add((Object)(stack == null ? ItemStack.field_190927_a : stack));
        }
        return items;
    }

    public void applyUpgrade(ItemStack upgrade, ItemStack tool) {
        LootWeaponEffect me;
        ItemShard upgradeItem = (ItemShard)upgrade.func_77973_b();
        LootRarity upgradeRarity = upgradeItem.getShardRariry();
        LootRarity toolRarity = LootRarity.fromId(LootItemHelper.getLootStringValue(tool, "rarity"));
        if (toolRarity == null || toolRarity != upgradeRarity) {
            return;
        }
        int upgrades = LootItemHelper.getLootIntValue(tool, "upgrades");
        if (upgrades <= 0) {
            return;
        }
        List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(tool);
        LootSet.LootSetType type = MysticToolsItems.getItemType(tool.func_77973_b());
        if (!effects.contains(LootWeaponEffect.ARMOR)) {
            effects.add(LootWeaponEffect.ARMOR);
        }
        if (!effects.contains(LootWeaponEffect.TOUGHNESS)) {
            effects.add(LootWeaponEffect.TOUGHNESS);
        }
        if ((me = LootWeaponEffect.getRandomExcluding(this.field_145850_b.field_73012_v, type, effects)) != null) {
            NBTTagList effectList = LootItemHelper.getLootTagList(tool, "effectList");
            effectList.func_74742_a((NBTBase)me.getNBT(this.field_145850_b.field_73012_v));
            if (me == LootWeaponEffect.LIFE_LONG) {
                tool.func_77978_p().func_74757_a("Unbreakable", true);
            }
            LootItemHelper.setLootTagList(tool, "effectList", effectList);
            upgrade.func_190918_g(1);
            if (--upgrades < 0) {
                upgrades = 0;
            }
            LootItemHelper.setLootIntValue(tool, "upgrades", upgrades);
        }
    }

    public void applyRepair() {
        ItemStack material = this.func_70301_a(0);
        ItemStack toRepair = this.func_70301_a(1);
        if (material == null || material == ItemStack.field_190927_a || material.func_190916_E() == 0 || toRepair == null || toRepair == ItemStack.field_190927_a || toRepair.func_190916_E() == 0) {
            return;
        }
        if (material.func_77973_b() == MysticToolsItems.UPGRADECHARM_COMMON || material.func_77973_b() == MysticToolsItems.UPGRADECHARM_RARE || material.func_77973_b() == MysticToolsItems.UPGRADECHARM_EPIC || material.func_77973_b() == MysticToolsItems.UPGRADECHARM_LEGENDARY) {
            this.applyUpgrade(material, toRepair);
            return;
        }
        if (material.func_77973_b() == MysticToolsItems.DIVINE_CHARM) {
            this.removeCurse(toRepair, material);
            return;
        }
        if (toRepair.func_77952_i() == 0) {
            return;
        }
        int newDamage = toRepair.func_77952_i() - (int)((double)toRepair.func_77958_k() * 0.33);
        if (newDamage < 0) {
            newDamage = 0;
        }
        if (material.func_77973_b() instanceof ItemShard) {
            LootRarity materialRarity = ((ItemShard)material.func_77973_b()).getShardRariry();
            LootRarity toolRarity = LootRarity.fromId(LootItemHelper.getLootStringValue(toRepair, "rarity"));
            if (materialRarity == null || toolRarity == null) {
                return;
            }
            if (materialRarity == toolRarity) {
                material.func_190918_g(1);
                toRepair.func_77964_b(newDamage);
            }
        }
    }

    public void removeCurse(ItemStack tool, ItemStack upgrade) {
        List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(tool);
        for (LootWeaponEffect effect : effects) {
            if (effect.getType() != LootWeaponEffect.EffectType.CURSE) continue;
            NBTTagList curseList = LootItemHelper.getLootTagList(tool, "effectList");
            curseList.func_74744_a(effects.indexOf(effect));
            System.out.println(curseList.toString());
            effects.remove(effect);
            upgrade.func_190918_g(1);
            return;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound c = super.func_189515_b(compound);
        c.func_74768_a("disenchantCounter", this.disenchantCounter);
        c.func_74768_a("disenchantStep", this.disenchantStep);
        c.func_74757_a("disenchaning", this.disenchaning);
        return c;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.disenchantCounter = compound.func_74762_e("disenchantCounter");
        this.disenchantStep = compound.func_74762_e("disenchantStep");
        this.disenchaning = compound.func_74767_n("disenchaning");
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

