/*
 * Decompiled with CFR 0.152.
 */
package binary404.MysticTools.util;

import binary404.MysticTools.Client.settings.KeyBindings;
import binary404.MysticTools.Config;
import binary404.MysticTools.MysticTools;
import binary404.MysticTools.item.MysticToolsItems;
import binary404.MysticTools.loot.ILootEffectAction;
import binary404.MysticTools.loot.LootItemHelper;
import binary404.MysticTools.loot.LootWeaponEffect;
import binary404.MysticTools.loot.item.IMysticTool;
import binary404.MysticTools.loot.item.ItemWeaponBow;
import binary404.MysticTools.util.network.PacketJetpack;
import binary404.MysticTools.util.network.PacketLootBrag;
import binary404.MysticTools.util.network.PacketToolUse;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack toRepair = event.getLeft();
        ItemStack ingredient = event.getRight();
        if (toRepair.func_190926_b() || ingredient.func_190926_b()) {
            return;
        }
        ArrayList<Item> modItems = new ArrayList<Item>();
        modItems.add(MysticToolsItems.ARMOR_HELMET);
        modItems.add(MysticToolsItems.ARMOR_CHESTPLATE);
        modItems.add(MysticToolsItems.ARMOR_LEGGINGS);
        modItems.add(MysticToolsItems.ARMOR_BOOTS);
        modItems.add(MysticToolsItems.WEAPONSWORD);
        modItems.add(MysticToolsItems.TOOL_AXE);
        modItems.add(MysticToolsItems.TOOL_PICKAXE);
        modItems.add(MysticToolsItems.TOOL_SHOVEL);
        if (modItems.contains(toRepair.func_77973_b()) && toRepair.func_77973_b() == ingredient.func_77973_b() && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAnvilRepair(AnvilRepairEvent event) {
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        EntityPlayer player;
        Entity sourceEntity = event.getSource().func_76346_g();
        if (sourceEntity != null && !sourceEntity.field_70170_p.field_72995_K && sourceEntity instanceof EntityPlayer && (player = (EntityPlayer)sourceEntity).func_184614_ca().func_77973_b() == MysticToolsItems.WEAPONSWORD) {
            ItemStack stack = player.func_184614_ca();
            List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(stack);
            if (effects.contains(LootWeaponEffect.getById("leechlife"))) {
                float damageInflicted = Math.min(event.getAmount(), event.getEntityLiving().func_110143_aJ());
                int amplifier = LootWeaponEffect.getAmplifierFromStack(stack, "leechlife");
                float leech = damageInflicted * ((float)amplifier / 100.0f);
                player.func_70691_i(leech);
            } else if (effects.contains(LootWeaponEffect.getById("curse_life"))) {
                float damageInflicted = Math.min(event.getAmount(), event.getEntityLiving().func_110143_aJ());
                float leech = damageInflicted / 3.0f;
                player.func_70097_a(DamageSource.field_76376_m, leech);
            }
        }
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent event) {
        if (event.getSource().func_76346_g() != null) {
            Entity target = event.getEntity();
            Entity source = event.getSource().func_76346_g();
            if (target instanceof EntityPlayer && source instanceof EntityLiving) {
                for (ItemStack stack : target.func_184193_aE()) {
                    List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(stack);
                    if (!effects.contains(LootWeaponEffect.getById("toxic"))) continue;
                    int amplifier = LootWeaponEffect.getAmplifierFromStack(stack, "toxic");
                    int duration = LootWeaponEffect.getDurationFromStack(stack, "toxic");
                    ((EntityLiving)source).func_70690_d(new PotionEffect(MobEffects.field_82731_v, duration * 2, amplifier));
                }
            }
        }
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.getHarvester();
        if (player != null && !player.field_70170_p.field_72995_K) {
            ArrayList<Item> tools = new ArrayList<Item>();
            tools.add(MysticToolsItems.TOOL_AXE);
            tools.add(MysticToolsItems.TOOL_PICKAXE);
            tools.add(MysticToolsItems.TOOL_SHOVEL);
            ItemStack tool = player.func_184614_ca();
            if (tools.contains(tool.func_77973_b())) {
                List<LootWeaponEffect> effects = LootWeaponEffect.getEffectList(tool);
                for (LootWeaponEffect effect : effects) {
                    ILootEffectAction action = effect.getAction();
                    if (action == null) continue;
                    action.handleHarvest(player, tool, event.getDrops());
                }
            }
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
    }

    @SubscribeEvent
    public void sleepingLocationCheck(SleepingLocationCheckEvent event) {
        ItemStack stack;
        if (event.getEntityPlayer().func_70608_bn() && !event.getEntityPlayer().field_70170_p.func_72935_r() && LootItemHelper.hasEffect(stack = event.getEntityPlayer().func_184614_ca(), LootWeaponEffect.getById("sleep"))) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootPool main = event.getTable().getPool("main");
        if (main == null) {
            return;
        }
        if (event.getName().equals((Object)LootTableList.field_186425_g) || event.getName().equals((Object)LootTableList.field_186426_h) || event.getName().equals((Object)LootTableList.field_186427_i) || event.getName().equals((Object)LootTableList.field_186428_j) || event.getName().equals((Object)LootTableList.field_186430_l) || event.getName().equals((Object)LootTableList.field_186429_k)) {
            this.addPoolEntry(main, MysticToolsItems.SHARD, Config.commonBaseRarity + 12);
            this.addPoolEntry(main, MysticToolsItems.WEAPONCASE, Config.commonBaseRarity + 8);
        } else if (event.getName().equals((Object)LootTableList.field_186431_m) || event.getName().equals((Object)LootTableList.field_186421_c)) {
            this.addPoolEntry(main, MysticToolsItems.SHARD, Config.commonBaseRarity + 12);
            this.addPoolEntry(main, MysticToolsItems.WEAPONCASE, Config.commonBaseRarity + 11);
        } else if (event.getName().equals((Object)LootTableList.field_186422_d)) {
            this.addPoolEntry(main, MysticToolsItems.WEAPONCASE, Config.commonBaseRarity + 16);
        } else if (event.getName().equals((Object)LootTableList.field_186424_f)) {
            this.addPoolEntry(main, MysticToolsItems.SHARD, Config.commonBaseRarity + 12);
            this.addPoolEntry(main, MysticToolsItems.WEAPONCASE, Config.commonBaseRarity + 1);
        } else if (event.getName().equals((Object)LootTableList.field_186423_e)) {
            this.addPoolEntry(main, MysticToolsItems.SHARD, Config.commonBaseRarity + 12);
            this.addPoolEntry(main, MysticToolsItems.WEAPONCASE, Config.commonBaseRarity);
        }
    }

    private void addPoolEntry(LootPool lootPool, Item item, int weight) {
        lootPool.addEntry((LootEntry)new LootEntryItem(item, weight, 0, new LootFunction[0], new LootCondition[0], "mystictools:" + item.func_77658_a().substring(5)));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onFOVUpdate(FOVUpdateEvent event) {
        ItemWeaponBow item;
        if (!event.getEntity().func_184587_cr()) {
            return;
        }
        ItemStack stack = event.getEntity().func_184607_cu();
        if (stack != null && stack.func_77973_b() instanceof ItemWeaponBow && (item = (ItemWeaponBow)stack.func_77973_b()).updatesFOV()) {
            float newfov = event.getFov() / (event.getFov() + item.getFOVValue(stack) * this.getItemInUsePercentaje(event.getEntity(), item.getFOVSpeedFactor(stack)));
            event.setNewfov(newfov);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private float getItemInUsePercentaje(EntityPlayer player, float speedFactor) {
        if (player.func_184607_cu().func_77973_b() instanceof ItemWeaponBow) {
            ItemWeaponBow bow = (ItemWeaponBow)player.func_184607_cu().func_77973_b();
            float maxUse = bow.getFOVDuration(player.func_184607_cu());
            float curUse = player.func_184605_cv();
            float percent = 0.0f;
            percent *= speedFactor * ((percent = maxUse - (maxUse - ((float)bow.func_77626_a(player.func_184607_cu()) - curUse))) > 100.0f ? 1.0f : percent / 100.0f);
            percent /= maxUse;
            percent *= 1.0f + percent;
            return percent > 1.0f ? 1.0f : percent;
        }
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        boolean f = Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d();
        boolean b = Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d();
        boolean l = Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d();
        boolean r = Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d();
        boolean j = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        boolean s = Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151470_d();
        if (f || b || l || r || j || s) {
            MysticTools.packetPipeline.sendToServer(new PacketJetpack(f, b, l, r, j, s));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyHandle(InputEvent.KeyInputEvent event) {
        if (KeyBindings.activateEffect.func_151468_f()) {
            MysticTools.packetPipeline.sendToServer(new PacketToolUse());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void keyboardEvent(GuiScreenEvent.KeyboardInputEvent.Post event) {
        ItemStack stack;
        GuiContainer gui;
        Slot slot;
        if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74310_D) && event.getGui() instanceof GuiContainer && GuiScreen.func_146272_n() && (slot = (gui = (GuiContainer)event.getGui()).getSlotUnderMouse()) != null && slot.field_75224_c != null && !"tmp".equals(slot.field_75224_c.func_70005_c_()) && !(stack = slot.func_75211_c()).func_190926_b() && stack.func_77973_b() instanceof IMysticTool) {
            MysticTools.packetPipeline.sendToServer(new PacketLootBrag(stack));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack chestplate = event.player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (chestplate != null && !chestplate.func_190926_b() && LootItemHelper.hasEffect(chestplate, LootWeaponEffect.JETPACK) && !event.player.field_70122_E) {
            int hover = LootWeaponEffect.getAmplifierFromStack(chestplate, LootWeaponEffect.JETPACK.getId());
            double factor = 1.0 - (double)hover / 100.0;
            if (event.player.func_70093_af()) {
                factor = 0.97;
            }
            if (event.player.field_70181_x < 0.0) {
                event.player.field_70181_x *= factor;
                event.player.field_70143_R = (float)((double)event.player.field_70143_R * factor);
            }
        }
    }
}

